/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolQueue
extends USymbol {
    private final double dx = 5.0;

    USymbolQueue() {
    }

    public SkinParameter getSkinParameter() {
        return SkinParameter.QUEUE;
    }

    private void drawQueue(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(5.0, 0.0);
        uPath.lineTo(d - 5.0, 0.0);
        uPath.cubicTo(d, 0.0, d, d2 / 2.0, d, d2 / 2.0);
        uPath.cubicTo(d, d2 / 2.0, d, d2, d - 5.0, d2);
        uPath.lineTo(5.0, d2);
        uPath.cubicTo(0.0, d2, 0.0, d2 / 2.0, 0.0, d2 / 2.0);
        uPath.cubicTo(0.0, d2 / 2.0, 0.0, 0.0, 5.0, 0.0);
        uGraphic.draw(uPath);
        UPath uPath2 = this.getClosingPath(d, d2);
        uGraphic.apply(new UChangeBackColor(null)).draw(uPath2);
    }

    private UPath getClosingPath(double d, double d2) {
        UPath uPath = new UPath();
        uPath.moveTo(d - 5.0, 0.0);
        uPath.cubicTo(d - 10.0, 0.0, d - 10.0, d2 / 2.0, d - 10.0, d2 / 2.0);
        uPath.cubicTo(d - 10.0, d2, d - 5.0, d2, d - 5.0, d2);
        return uPath;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(5.0, 15.0, 5.0, 5.0);
    }

    public TextBlock asSmall(TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolQueue.this.drawQueue(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolQueue.this.getMargin();
                TextBlock textBlock = TextBlockUtils.mergeTB(textBlock3, textBlock2, HorizontalAlignment.CENTER);
                MyUGraphicQueue myUGraphicQueue = new MyUGraphicQueue(uGraphic, dimension2D.getWidth() - 10.0, dimension2D.getWidth() - 5.0, dimension2D.getHeight());
                textBlock.drawU(myUGraphicQueue.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock3.calculateDimension(stringBounder);
                return USymbolQueue.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(TextBlock textBlock, TextBlock textBlock2, double d, double d2, SymbolContext symbolContext) {
        throw new UnsupportedOperationException();
    }

    public boolean manageHorizontalLine() {
        return true;
    }

    class MyUGraphicQueue
    extends AbstractUGraphicHorizontalLine
    implements Stencil {
        private final double x1;
        private final double x2;
        private final double fullHeight;

        protected AbstractUGraphicHorizontalLine copy(UGraphic uGraphic) {
            return new MyUGraphicQueue(uGraphic, this.x1, this.x2, this.fullHeight);
        }

        public MyUGraphicQueue(UGraphic uGraphic, double d, double d2, double d3) {
            super(uGraphic);
            this.x1 = d;
            this.x2 = d2;
            this.fullHeight = d3;
        }

        protected void drawHline(UGraphic uGraphic, UHorizontalLine uHorizontalLine, UTranslate uTranslate) {
            uHorizontalLine.drawLineInternal(uGraphic, this, uTranslate.getDy(), uHorizontalLine.getStroke());
        }

        public double getStartingX(StringBounder stringBounder, double d) {
            return 0.0;
        }

        public double getEndingX(StringBounder stringBounder, double d) {
            double d2 = this.fullHeight / 2.0;
            double d3 = d <= d2 ? 1.0 - d / d2 : (d - d2) / d2;
            return (this.x2 - this.x1) * d3 + this.x1;
        }
    }
}

