/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolStack
extends USymbol {
    USymbolStack() {
    }

    public SkinParameter getSkinParameter() {
        return SkinParameter.STACK;
    }

    private void drawQueue(UGraphic uGraphic, double d, double d2, boolean bl, double d3) {
        URectangle uRectangle = new URectangle(d - 30.0, d2, d3, d3);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.apply(new UChangeColor(null)).apply(new UTranslate(15.0, 0.0)).draw(uRectangle);
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(15.0, 0.0);
        uPath.lineTo(15.0, d2);
        uPath.lineTo(d - 15.0, d2);
        uPath.lineTo(d - 15.0, 0.0);
        uPath.lineTo(d, 0.0);
        uGraphic.apply(new UChangeBackColor(null)).draw(uPath);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(25.0, 25.0, 10.0, 10.0);
    }

    public TextBlock asSmall(TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = UGraphicStencil.create(uGraphic, USymbolStack.this.getRectangleStencil(dimension2D), new UStroke());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolStack.this.drawQueue(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolStack.this.getMargin();
                TextBlock textBlock = TextBlockUtils.mergeTB(textBlock3, textBlock2, HorizontalAlignment.CENTER);
                textBlock.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock3.calculateDimension(stringBounder);
                return USymbolStack.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(TextBlock textBlock, TextBlock textBlock2, double d, double d2, SymbolContext symbolContext) {
        throw new UnsupportedOperationException();
    }

    public boolean manageHorizontalLine() {
        return true;
    }
}

