/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic.color;

import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public class ColorParser {
    private static final String COLOR_REGEXP = "#\\w+[-\\\\|/]?\\w+";
    private static final String PART2 = "#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+";
    private static final String COLORS_REGEXP = "(?:#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+)|(?:#\\w+[-\\\\|/]?\\w+)";
    private final RegexLeaf regex;
    private final String name;
    private final ColorType mainType;

    private ColorParser(String string, RegexLeaf regexLeaf, ColorType colorType) {
        this.regex = regexLeaf;
        this.name = string;
        this.mainType = colorType;
    }

    public Colors getColor(RegexResult regexResult, IHtmlColorSet iHtmlColorSet) {
        if (this.mainType == null) {
            throw new IllegalStateException();
        }
        String string = regexResult.getLazzy(this.name, 0);
        if (string == null) {
            return Colors.empty();
        }
        return new Colors(string, iHtmlColorSet, this.mainType);
    }

    public static ColorParser simpleColor(ColorType colorType) {
        return ColorParser.simpleColor(colorType, "COLOR");
    }

    public static ColorParser simpleColor(ColorType colorType, String string) {
        return new ColorParser(string, new RegexLeaf(string, "((?:#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+)|(?:#\\w+[-\\\\|/]?\\w+))?"), colorType);
    }

    public static ColorParser mandatoryColor(ColorType colorType) {
        return new ColorParser("COLOR", new RegexLeaf("COLOR", "((?:#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+)|(?:#\\w+[-\\\\|/]?\\w+))"), colorType);
    }

    public static ColorParser simpleColor(String string, ColorType colorType) {
        return new ColorParser("COLOR", new RegexLeaf("COLOR", "(?:" + string + " (" + COLORS_REGEXP + "))?"), colorType);
    }

    public static RegexLeaf exp1() {
        return ColorParser.simpleColor(null).regex;
    }

    public static RegexLeaf exp2() {
        return new RegexLeaf("BACKCOLOR", "(#\\w+[-\\\\|/]?\\w+)?");
    }

    public static RegexLeaf exp3() {
        return new RegexLeaf("BACKCOLOR2", "(#\\w+[-\\\\|/]?\\w+)?");
    }

    public static RegexLeaf exp4() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+):)?");
    }

    public static RegexLeaf exp6() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+)\\|)?");
    }

    public static RegexLeaf exp7() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+))?");
    }

    public RegexLeaf getRegex() {
        return this.regex;
    }
}

