/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdot;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.cgraph.subg__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.Agedge_s;
import h.Agnode_s;
import h.Agnodeinfo_t;
import h.Agraph_s;
import h.Agraphinfo_t;
import h.GVC_s;
import h.ST_boxf;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Removeable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.jdot.JDotPath;
import net.sourceforge.plantuml.jdot.YMirror;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotDataImageBuilder;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import smetana.core.CString;
import smetana.core.JUtils;
import smetana.core.Macro;
import smetana.core.Z;
import smetana.core.__ptr__;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CucaDiagramFileMakerJDot
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;
    private final Map<ILeaf, Agnode_s> nodes = new LinkedHashMap<ILeaf, Agnode_s>();
    private final Map<Link, Agedge_s> edges = new LinkedHashMap<Link, Agedge_s>();
    private final Map<IGroup, Agraph_s> clusters = new LinkedHashMap<IGroup, Agraph_s>();
    private Map<IGroup, ILeaf> emptyGroups = new HashMap<IGroup, ILeaf>();
    private final DotStringFactory dotStringFactory;
    private static final Lock lock = new ReentrantLock();

    public CucaDiagramFileMakerJDot(CucaDiagram cucaDiagram, StringBounder stringBounder) {
        this.diagram = cucaDiagram;
        this.stringBounder = stringBounder;
        this.dotStringFactory = new DotStringFactory(stringBounder, cucaDiagram);
        this.printGroups(cucaDiagram.getRootGroup());
        this.printEntities(this.getUnpackagedEntities());
    }

    public void drawGroup(UGraphic uGraphic, YMirror yMirror, IGroup iGroup, Agraph_s agraph_s) {
        JUtils.LOG2("drawGroup");
        __ptr__ __ptr__2 = Macro.AGDATA(agraph_s).castTo(Agraphinfo_t.class);
        ST_boxf sT_boxf = (ST_boxf)__ptr__2.getStruct("bb");
        double d = sT_boxf.LL.x;
        double d2 = sT_boxf.LL.y;
        double d3 = sT_boxf.UR.x;
        double d4 = sT_boxf.UR.y;
        if (yMirror != null) {
            double d5 = d4;
            d4 = yMirror.getMirrored(d2);
            d2 = yMirror.getMirrored(d5);
        }
        Cluster cluster = this.dotStringFactory.getBibliotekon().getCluster(iGroup);
        cluster.setPosition(d, d2, d3, d4);
        JUtils.LOG2("cluster=" + cluster);
        cluster.drawU(uGraphic, new UStroke(1.5), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
    }

    private void printGroups(IGroup iGroup) {
        for (IGroup iGroup2 : this.diagram.getChildrenGroups(iGroup)) {
            if (iGroup2.isRemoved()) continue;
            if (this.diagram.isEmpty(iGroup2) && iGroup2.getGroupType() == GroupType.PACKAGE) {
                ILeaf iLeaf = this.diagram.getEntityFactory().createLeaf(iGroup2.getCode(), iGroup2.getDisplay(), LeafType.EMPTY_PACKAGE, iGroup2.getParentContainer(), null, this.diagram.getNamespaceSeparator());
                this.emptyGroups.put(iGroup2, iLeaf);
                USymbol uSymbol = iGroup2.getUSymbol();
                iLeaf.setUSymbol(uSymbol);
                iLeaf.setStereotype(iGroup2.getStereotype());
                if (iGroup2.getColors(this.diagram.getSkinParam()).getColor(ColorType.BACK) == null) {
                    ColorParam colorParam = uSymbol == null ? ColorParam.packageBackground : uSymbol.getColorParamBack();
                    HtmlColor htmlColor = this.diagram.getSkinParam().getHtmlColor(colorParam, iGroup2.getStereotype(), false);
                    iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, htmlColor == null ? this.diagram.getSkinParam().getBackgroundColor() : htmlColor);
                } else {
                    iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, iGroup2.getColors(this.diagram.getSkinParam()).getColor(ColorType.BACK));
                }
                this.printEntityNew(iLeaf);
                continue;
            }
            this.printGroup(iGroup2);
        }
    }

    private void printGroup(IGroup iGroup) {
        if (iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int n = 0;
        int n2 = 0;
        TextBlock textBlock = this.getTitleBlock(iGroup);
        TextBlock textBlock2 = this.getStereoBlock(iGroup);
        TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
        Dimension2D dimension2D = textBlock3.calculateDimension(this.stringBounder);
        if (dimension2D.getWidth() > 0.0) {
            List<Member> list = iGroup.getBodier().getFieldsToDisplay();
            AbstractTextBlock abstractTextBlock = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, this.diagram.getSkinParam(), iGroup.getStereotype(), null);
            Dimension2D dimension2D2 = abstractTextBlock.calculateDimension(this.stringBounder);
            double d = dimension2D2.getHeight();
            double d2 = dimension2D2.getWidth();
            double d3 = d > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = iGroup.getUSymbol();
            int n3 = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int n4 = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            n = (int)Math.max(dimension2D.getWidth(), d2) + n4;
            n2 = (int)(dimension2D.getHeight() + d + d3 + (double)n3);
        }
        this.dotStringFactory.openCluster(iGroup, n, n2, textBlock, textBlock2);
        this.printEntities(iGroup.getLeafsDirect());
        this.printGroups(iGroup);
        this.dotStringFactory.closeCluster();
    }

    private void printEntities(Collection<ILeaf> collection) {
        for (ILeaf iLeaf : collection) {
            if (iLeaf.isRemoved()) continue;
            this.printEntity(iLeaf);
        }
    }

    private void exportEntities(Agraph_s agraph_s, Collection<ILeaf> collection) {
        for (ILeaf iLeaf : collection) {
            if (iLeaf.isRemoved()) continue;
            this.exportEntity(agraph_s, iLeaf);
        }
    }

    private void exportEntity(Agraph_s agraph_s, ILeaf iLeaf) {
        Shape shape = this.dotStringFactory.getBibliotekon().getShape(iLeaf);
        Agnode_s agnode_s = node__c.agnode(agraph_s, new CString(shape.getUid()), true);
        attr__c.agsafeset(agnode_s, new CString("shape"), new CString("box"), new CString(""));
        String string = "" + shape.getWidth() / 72.0;
        String string2 = "" + shape.getHeight() / 72.0;
        attr__c.agsafeset(agnode_s, new CString("width"), new CString(string), new CString(""));
        attr__c.agsafeset(agnode_s, new CString("height"), new CString(string2), new CString(""));
        this.nodes.put(iLeaf, agnode_s);
    }

    private void printEntity(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage iEntityImage = this.printEntityInternal(iLeaf);
        Dimension2D dimension2D = iEntityImage.calculateDimension(this.stringBounder);
        Shape shape = new Shape(iEntityImage, iEntityImage.getShapeType(), dimension2D.getWidth(), dimension2D.getHeight(), this.dotStringFactory.getColorSequence(), iLeaf.isTop(), iEntityImage.getShield(this.stringBounder), iLeaf.getEntityPosition());
        this.dotStringFactory.addShape(shape);
        this.getBibliotekon().putShape(iLeaf, shape);
    }

    private TextBlock getTitleBlock(IGroup iGroup) {
        Display display = iGroup.getDisplay();
        if (display == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        FontConfiguration fontConfiguration = iGroup.getFontConfigurationForTitle(iSkinParam);
        return display.create(fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
    }

    private TextBlock getStereoBlock(IGroup iGroup) {
        List<String> list;
        Stereotype stereotype = iGroup.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        if (stereotype.getSprite() != null && (list = this.diagram.getSkinParam().getSprite(stereotype.getSprite())) != null) {
            return list.asTextBlock(stereotype.getHtmlColor(), 1.0);
        }
        list = stereotype.getLabels(this.diagram.getSkinParam().useGuillemet());
        if (list == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean bl = this.diagram.showPortion(EntityPortion.STEREOTYPE, iGroup);
        if (!bl) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = FontParam.PACKAGE_STEREOTYPE;
        return Display.create((Collection<? extends CharSequence>)list).create(new FontConfiguration(this.diagram.getSkinParam(), fontParam, stereotype), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
        for (ILeaf iLeaf : this.diagram.getLeafsvalues()) {
            if (this.diagram.getEntityFactory().getRootGroup() != iLeaf.getParentContainer()) continue;
            arrayList.add(iLeaf);
        }
        return arrayList;
    }

    private void printCluster(Agraph_s agraph_s, Cluster cluster) {
        for (Shape shape : cluster.getShapes()) {
            Agnode_s agnode_s = node__c.agnode(agraph_s, new CString(shape.getUid()), true);
            attr__c.agsafeset(agnode_s, new CString("shape"), new CString("box"), new CString(""));
            String string = "" + shape.getWidth() / 72.0;
            String string2 = "" + shape.getHeight() / 72.0;
            attr__c.agsafeset(agnode_s, new CString("width"), new CString(string), new CString(""));
            attr__c.agsafeset(agnode_s, new CString("height"), new CString(string2), new CString(""));
            ILeaf iLeaf = this.dotStringFactory.getBibliotekon().getLeaf(shape);
            this.nodes.put(iLeaf, agnode_s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        lock.lock();
        try {
            ImageData imageData = this.createFileLocked(outputStream, list, fileFormatOption);
            return imageData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createFileLocked(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        for (ILeaf object2 : this.diagram.getLeafsvalues()) {
            this.printEntityNew(object2);
        }
        Z.open();
        try {
            Agraph_s agraph_s = graph__c.agopen(new CString("g"), Z.z().Agdirected, null);
            this.exportEntities(agraph_s, this.getUnpackagedEntities());
            this.exportGroups(agraph_s, this.diagram.getEntityFactory().getRootGroup());
            for (Link link : this.diagram.getLinks()) {
                Agedge_s agedge_s = this.createEdge(agraph_s, link);
                if (agedge_s == null) continue;
                this.edges.put(link, agedge_s);
            }
            GVC_s gVC_s = gvc__c.gvContext(new Object[0]);
            gvlayout__c.gvLayoutJobs(gVC_s, agraph_s);
            ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam(), 1.0, fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null, null, 0.0, 10.0, this.diagram.getAnimation());
            imageBuilder.setUDrawable(new Drawing(null));
            Dimension2D dimension2D = imageBuilder.getFinalDimension(this.stringBounder);
            imageBuilder.setUDrawable(new Drawing(new YMirror(dimension2D.getHeight())));
            ImageData imageData = imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.diagram.seed(), outputStream);
            return imageData;
        }
        catch (Throwable throwable) {
            UmlDiagram.exportDiagramError(outputStream, throwable, fileFormatOption, this.diagram.seed(), this.diagram.getMetadata(), this.diagram.getFlashData(), CucaDiagramFileMakerJDot.getFailureText3(throwable));
            ImageDataSimple imageDataSimple = new ImageDataSimple();
            return imageDataSimple;
        }
        finally {
            Z.close();
        }
    }

    private void exportGroups(Agraph_s agraph_s, IGroup iGroup) {
        for (IGroup iGroup2 : this.diagram.getChildrenGroups(iGroup)) {
            if (iGroup2.isRemoved()) continue;
            if (this.diagram.isEmpty(iGroup2) && iGroup2.getGroupType() == GroupType.PACKAGE) {
                ILeaf iLeaf = this.emptyGroups.get(iGroup2);
                this.exportEntity(agraph_s, iLeaf);
                continue;
            }
            this.exportGroup(agraph_s, iGroup2);
        }
    }

    private void exportGroup(Agraph_s agraph_s, IGroup iGroup) {
        Cluster cluster = this.getBibliotekon().getCluster(iGroup);
        JUtils.LOG2("cluster = " + cluster.getClusterId());
        Agraph_s agraph_s2 = subg__c.agsubg(agraph_s, new CString(cluster.getClusterId()), true);
        if (cluster.isLabel()) {
            double d = cluster.getTitleAndAttributeWidth();
            double d2 = cluster.getTitleAndAttributeHeight() - 5;
            attr__c.agsafeset(agraph_s2, new CString("label"), Macro.createHackInitDimensionFromLabel((int)d, (int)d2), new CString(""));
        }
        this.exportEntities(agraph_s2, iGroup.getLeafsDirect());
        this.clusters.put(iGroup, agraph_s2);
        this.exportGroups(agraph_s2, iGroup);
    }

    private TextBlock getLabel(Link link) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.ARROW, null);
        TextBlock textBlock = link.getLabel().create(fontConfiguration, iSkinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), iSkinParam);
        if (TextBlockUtils.isEmpty(textBlock, this.stringBounder)) {
            return textBlock;
        }
        return TextBlockUtils.withMargin(textBlock, 1.0, 1.0);
    }

    private Agnode_s getAgnodeFromLeaf(IEntity iEntity) {
        Agnode_s agnode_s = this.nodes.get(iEntity);
        if (agnode_s != null) {
            return agnode_s;
        }
        String string = this.getBibliotekon().getShapeUid((ILeaf)iEntity);
        for (Map.Entry<ILeaf, Agnode_s> entry : this.nodes.entrySet()) {
            if (!string.equals(this.getBibliotekon().getShapeUid(entry.getKey()))) continue;
            return entry.getValue();
        }
        return null;
    }

    private Agedge_s createEdge(Agraph_s agraph_s, Link link) {
        Agnode_s agnode_s = this.getAgnodeFromLeaf(link.getEntity1());
        Agnode_s agnode_s2 = this.getAgnodeFromLeaf(link.getEntity2());
        if (agnode_s == null) {
            return null;
        }
        if (agnode_s2 == null) {
            return null;
        }
        Agedge_s agedge_s = edge__c.agedge(agraph_s, agnode_s, agnode_s2, null, true);
        attr__c.agsafeset(agedge_s, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(agedge_s, new CString("arrowhead"), new CString("none"), new CString(""));
        int n = link.getLength();
        attr__c.agsafeset(agedge_s, new CString("minlen"), new CString("" + (n - 1)), new CString(""));
        TextBlock textBlock = this.getLabel(link);
        if (!TextBlockUtils.isEmpty(textBlock, this.stringBounder)) {
            Dimension2D dimension2D = textBlock.calculateDimension(this.stringBounder);
            CString cString = Macro.createHackInitDimensionFromLabel((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
            attr__c.agsafeset(agedge_s, new CString("label"), cString, new CString(""));
        }
        return agedge_s;
    }

    private static List<String> getFailureText3(Throwable throwable) {
        throwable.printStackTrace();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("An error has occured : " + throwable);
        String string = StringUtils.rot(QuoteUtils.getSomeQuote());
        arrayList.add("<i>" + string);
        arrayList.add(" ");
        GraphvizCrash.addProperties(arrayList);
        arrayList.add(" ");
        arrayList.add("Sorry, the subproject Smetana is not finished yet...");
        arrayList.add(" ");
        arrayList.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        arrayList.add("post to <b>http://plantuml.com/qa</b> to solve this issue.");
        arrayList.add(" ");
        return arrayList;
    }

    private void printEntityNew(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage iEntityImage = this.printEntityInternal(iLeaf);
        Dimension2D dimension2D = iEntityImage.calculateDimension(this.stringBounder);
        Shape shape = new Shape(iEntityImage, iEntityImage.getShapeType(), dimension2D.getWidth(), dimension2D.getHeight(), this.dotStringFactory.getColorSequence(), iLeaf.isTop(), iEntityImage.getShield(this.stringBounder), iLeaf.getEntityPosition());
        this.getBibliotekon().putShape(iLeaf, shape);
    }

    private Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    private IEntityImage printEntityInternal(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getSvekImage() == null) {
            ISkinParam iSkinParam = this.diagram.getSkinParam();
            if (iSkinParam.sameClassWidth()) {
                throw new UnsupportedOperationException();
            }
            return DotDataImageBuilder.createEntityImageBlock(iLeaf, iSkinParam, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getUmlDiagramType(), this.diagram.getLinks());
        }
        return iLeaf.getSvekImage();
    }

    class Drawing
    implements UDrawable {
        private final YMirror ymirror;

        public Drawing(YMirror yMirror) {
            this.ymirror = yMirror;
        }

        public void drawU(UGraphic uGraphic) {
            __ptr__ __ptr__2;
            Removeable removeable;
            for (Map.Entry entry : CucaDiagramFileMakerJDot.this.clusters.entrySet()) {
                CucaDiagramFileMakerJDot.this.drawGroup(uGraphic, this.ymirror, (IGroup)entry.getKey(), (Agraph_s)entry.getValue());
            }
            for (Map.Entry entry : CucaDiagramFileMakerJDot.this.nodes.entrySet()) {
                removeable = (ILeaf)entry.getKey();
                __ptr__2 = (Agnode_s)entry.getValue();
                Point2D point2D = this.getCorner((Agnode_s)__ptr__2);
                Shape shape = CucaDiagramFileMakerJDot.this.dotStringFactory.getBibliotekon().getShape((IEntity)removeable);
                IEntityImage iEntityImage = shape.getImage();
                iEntityImage.drawU(uGraphic.apply(new UTranslate(point2D)));
            }
            for (Map.Entry entry : CucaDiagramFileMakerJDot.this.edges.entrySet()) {
                removeable = (Link)entry.getKey();
                __ptr__2 = (Agedge_s)entry.getValue();
                new JDotPath((Link)removeable, (Agedge_s)__ptr__2, this.ymirror, CucaDiagramFileMakerJDot.this.diagram, CucaDiagramFileMakerJDot.this.getLabel((Link)removeable)).drawU(uGraphic);
            }
        }

        private Point2D getCorner(Agnode_s agnode_s) {
            Agnodeinfo_t agnodeinfo_t = (Agnodeinfo_t)Macro.AGDATA(agnode_s).castTo(Agnodeinfo_t.class);
            double d = agnodeinfo_t.getDouble("width") * 72.0;
            double d2 = agnodeinfo_t.getDouble("height") * 72.0;
            double d3 = agnodeinfo_t.getStruct("coord").getDouble("x");
            double d4 = agnodeinfo_t.getStruct("coord").getDouble("y");
            if (this.ymirror == null) {
                return new Point2D.Double(d3 - d / 2.0, d4 - d2 / 2.0);
            }
            return this.ymirror.getMirrored(new Point2D.Double(d3 - d / 2.0, d4 + d2 / 2.0));
        }
    }
}

