/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdot;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class YMirror {
    private final double max;

    public YMirror(double d) {
        this.max = d;
    }

    public double getMirrored(double d) {
        if (d < 0.0 || d > this.max) {
            throw new IllegalArgumentException();
        }
        return this.max - d;
    }

    public Point2D getMirrored(Point2D point2D) {
        return new Point2D.Double(point2D.getX(), this.max - point2D.getY());
    }

    public DotPath getMirrored(DotPath dotPath) {
        DotPath dotPath2 = new DotPath();
        for (CubicCurve2D.Double double_ : dotPath.getBeziers()) {
            dotPath2 = dotPath2.addCurve(this.getMirrored(double_.getP1()), this.getMirrored(double_.getCtrlP1()), this.getMirrored(double_.getCtrlP2()), this.getMirrored(double_.getP2()));
        }
        return dotPath2;
    }

    public UTranslate getMirrored(UTranslate uTranslate) {
        return new UTranslate(uTranslate.getDx(), this.max - uTranslate.getDy());
    }
}

