/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.jungle.GTile;
import net.sourceforge.plantuml.jungle.GTileGeometry;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GTileLeftRight
extends AbstractTextBlock
implements GTile {
    private final GTile left;
    private final GTile right;
    private final double space;
    private final double step = 5.0;

    public GTileLeftRight(GTile gTile, GTile gTile2, double d) {
        this.left = gTile;
        this.right = gTile2;
        this.space = d;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        GTileGeometry gTileGeometry = this.left.calculateDimension(stringBounder);
        GTileGeometry gTileGeometry2 = this.right.calculateDimension(stringBounder);
        GTileGeometry gTileGeometry3 = this.calculateDimension(stringBounder);
        double d = ((Dimension2D)gTileGeometry3).getHeight() - gTileGeometry.getHeight();
        double d2 = ((Dimension2D)gTileGeometry3).getHeight() - gTileGeometry2.getHeight();
        this.left.drawU(uGraphic.apply(new UTranslate(0.0, d / 2.0)));
        double d3 = gTileGeometry.getWidth() + this.space;
        this.right.drawU(uGraphic.apply(new UTranslate(d3, d2 / 2.0)));
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        double d4 = gTileGeometry.getHeight() / (double)(gTileGeometry2.getWestPositions().size() + 1);
        double d5 = d4 + d / 2.0;
        for (Double d6 : gTileGeometry2.getWestPositions()) {
            this.line(uGraphic, gTileGeometry.getWidth(), d5, d3, d6 + d2 / 2.0);
            d5 += d4;
        }
    }

    private void line(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        UPath uPath = new UPath();
        uPath.moveTo(d, d2);
        uPath.lineTo(d + 5.0, d2);
        uPath.lineTo(d3 - 5.0, d4);
        uPath.lineTo(d3, d4);
        uGraphic.apply(new UTranslate(0.0, 0.0)).draw(uPath);
    }

    public GTileGeometry calculateDimension(StringBounder stringBounder) {
        GTileGeometry gTileGeometry = this.left.calculateDimension(stringBounder);
        GTileGeometry gTileGeometry2 = this.right.calculateDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(gTileGeometry.getWidth() + this.space + ((Dimension2D)gTileGeometry2).getHeight(), Math.max(gTileGeometry.getHeight(), ((Dimension2D)gTileGeometry2).getHeight()));
        double d = ((Dimension2D)dimension2DDouble).getHeight() - gTileGeometry.getHeight();
        double d2 = gTileGeometry.getWestPositions().get(0) + d / 2.0;
        return new GTileGeometry(dimension2DDouble, Arrays.asList(d2));
    }
}

