/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.jungle.GTile;
import net.sourceforge.plantuml.jungle.GTileGeometry;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTileStack
extends AbstractTextBlock
implements GTile {
    private final List<GTile> tiles;
    private final double space;

    public GTileStack(List<GTile> list, double d) {
        this.tiles = list;
        this.space = d;
        if (list.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        for (GTile gTile : this.tiles) {
            gTile.drawU(uGraphic);
            GTileGeometry gTileGeometry = gTile.calculateDimension(uGraphic.getStringBounder());
            uGraphic = uGraphic.apply(new UTranslate(0.0, ((Dimension2D)gTileGeometry).getHeight() + this.space));
        }
    }

    @Override
    public GTileGeometry calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (GTile gTile : this.tiles) {
            GTileGeometry gTileGeometry = gTile.calculateDimension(stringBounder);
            arrayList.add(d3 + gTileGeometry.getWestPositions().get(0));
            d2 += gTileGeometry.getHeight();
            d3 += gTileGeometry.getHeight() + this.space;
            d = Math.max(d, gTileGeometry.getWidth());
        }
        return new GTileGeometry(d, d2 += (double)(this.tiles.size() - 1) * this.space, arrayList);
    }
}

