/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.UDrawableUtils;
import net.sourceforge.plantuml.jungle.GNode;
import net.sourceforge.plantuml.jungle.GTileOneLevelFactory;
import net.sourceforge.plantuml.jungle.Needle;
import net.sourceforge.plantuml.jungle.Rendering;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.LimitFinder;

public class PSystemTree
extends AbstractPSystem {
    private GNode root;
    private List<GNode> stack = new ArrayList<GNode>();
    private final Rendering rendering = Rendering.NEEDLE;

    public DiagramDescription getDescription() {
        return new DiagramDescription("(Tree)");
    }

    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, null, null, 5.0, 5.0, null, false);
        if (this.rendering == Rendering.NEEDLE) {
            UDrawable uDrawable = Needle.getNeedle(this.root, 200.0, 0.0, 60.0);
            LimitFinder limitFinder = new LimitFinder(fileFormatOption.getDefaultStringBounder(), true);
            uDrawable.drawU(limitFinder);
            double d = limitFinder.getMinY();
            imageBuilder.setUDrawable(UDrawableUtils.move(uDrawable, 0.0, -d));
        } else {
            imageBuilder.setUDrawable(new GTileOneLevelFactory().createGTile(this.root));
        }
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    public CommandExecutionResult addParagraph(int n, String string) {
        if (n == 1 && this.root == null) {
            this.root = new GNode(Display.create(string));
            this.stack.add(this.root);
            return CommandExecutionResult.ok();
        }
        if (n == 1 && this.root != null) {
            return CommandExecutionResult.error("Not allowed 1");
        }
        GNode gNode = this.stack.get(n - 2);
        GNode gNode2 = gNode.addChild(Display.create(string));
        if (n > this.stack.size() + 1) {
            return CommandExecutionResult.error("Not allowed 2");
        }
        if (n - 1 == this.stack.size()) {
            this.stack.add(gNode2);
        } else {
            this.stack.set(n - 1, gNode2);
        }
        return CommandExecutionResult.ok();
    }
}

