/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

public class EvalMath {
    private final String str;
    private int pos = -1;
    private char ch;

    public EvalMath(String string) {
        this.str = string;
    }

    private void nextChar() {
        ++this.pos;
        this.ch = this.pos < this.str.length() ? this.str.charAt(this.pos) : (char)'\u0000';
    }

    private boolean eat(int n) {
        while (this.ch == ' ') {
            this.nextChar();
        }
        if (this.ch == n) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private double parseExpression() {
        double d = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                d += this.parseTerm();
                continue;
            }
            if (!this.eat(45)) break;
            d -= this.parseTerm();
        }
        return d;
    }

    private double parseTerm() {
        double d = this.parseFactor();
        while (true) {
            if (this.eat(42)) {
                d *= this.parseFactor();
                continue;
            }
            if (!this.eat(47)) break;
            d /= this.parseFactor();
        }
        return d;
    }

    private double parseFactor() {
        double d;
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return -this.parseFactor();
        }
        int n = this.pos;
        if (this.eat(40)) {
            d = this.parseExpression();
            this.eat(41);
        } else if (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
            while (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
                this.nextChar();
            }
            d = Double.parseDouble(this.str.substring(n, this.pos));
        } else {
            if (this.ch >= 'a' && this.ch <= 'z') {
                while (this.ch >= 'a' && this.ch <= 'z') {
                    this.nextChar();
                }
                String string = this.str.substring(n, this.pos);
                double d2 = this.parseFactor();
                throw new RuntimeException("Unknown function: " + string);
            }
            throw new RuntimeException("Unexpected: " + this.ch);
        }
        return d;
    }

    public double eval() {
        this.nextChar();
        double d = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected: " + this.ch);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        EvalMath evalMath = new EvalMath("33+2*(4+1)");
        System.err.println(evalMath.eval());
    }
}

