/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.IfManagerNegatif;
import net.sourceforge.plantuml.preproc.IfManagerPositif;
import net.sourceforge.plantuml.preproc.NumericCompare;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.version.Version;

class IfManager
implements ReadLine {
    protected static final Pattern2 ifdefPattern = MyPattern.cmpile("^[%s]*!if(n)?def[%s]+(.+)$");
    protected static final Pattern2 ifcomparePattern = MyPattern.cmpile("^[%s]*!if[%s]+\\%(\\w+)\\%[%s]*(\\<|\\<=|\\>|\\>=|=|==|!=|\\<\\>)[%s]*(\\d+)$");
    protected static final Pattern2 elsePattern = MyPattern.cmpile("^[%s]*!else[%s]*$");
    protected static final Pattern2 endifPattern = MyPattern.cmpile("^[%s]*!endif[%s]*$");
    private final Defines defines;
    private final ReadLine source;
    private IfManager child;

    public IfManager(ReadLine readLine, Defines defines) {
        this.defines = defines;
        this.source = readLine;
    }

    public final CharSequence2 readLine() throws IOException {
        if (this.child != null) {
            CharSequence2 charSequence2 = this.child.readLine();
            if (charSequence2 != null) {
                return charSequence2;
            }
            this.child = null;
        }
        return this.readLineInternal();
    }

    protected CharSequence2 readLineInternal() throws IOException {
        CharSequence2 charSequence2 = this.source.readLine();
        if (charSequence2 == null) {
            return null;
        }
        Matcher2 matcher2 = ifcomparePattern.matcher(charSequence2);
        if (matcher2.find()) {
            int n;
            int n2 = this.getValue(matcher2.group(1));
            String string = matcher2.group(2);
            boolean bl = new NumericCompare(string).isCompareOk(n2, n = Integer.parseInt(matcher2.group(3)));
            this.child = bl ? new IfManagerPositif(this.source, this.defines) : new IfManagerNegatif(this.source, this.defines);
            return this.readLine();
        }
        matcher2 = ifdefPattern.matcher(charSequence2);
        if (matcher2.find()) {
            boolean bl = this.defines.isDefine(matcher2.group(2));
            if (matcher2.group(1) != null) {
                bl = !bl;
            }
            this.child = bl ? new IfManagerPositif(this.source, this.defines) : new IfManagerNegatif(this.source, this.defines);
            return this.readLine();
        }
        return charSequence2;
    }

    private int getValue(String string) {
        if (string.equalsIgnoreCase("PLANTUML_VERSION")) {
            return Version.versionPatched();
        }
        return 0;
    }

    public void close() throws IOException {
        this.source.close();
    }
}

