/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(CharSequence2 charSequence2, File file, String string, String string2) {
        this(StartDiagramExtractReader.getReadLine(charSequence2, file, string2), string, string2);
    }

    public StartDiagramExtractReader(CharSequence2 charSequence2, URL uRL, String string, String string2) {
        this(StartDiagramExtractReader.getReadLine(charSequence2, uRL, string2), string, string2);
    }

    private StartDiagramExtractReader(ReadLine readLine, String string, String string2) {
        int n = 0;
        String string3 = null;
        if (string != null && string.matches("\\d+")) {
            n = Integer.parseInt(string);
        } else {
            string3 = string;
        }
        if (n < 0) {
            n = 0;
        }
        this.raw = readLine;
        CharSequence2 charSequence2 = null;
        try {
            while ((charSequence2 = readLine.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(charSequence2) || !this.checkUid(string3, charSequence2)) continue;
                if (n == 0) {
                    return;
                }
                --n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Log.error("Error " + iOException);
        }
        this.finished = true;
    }

    private boolean checkUid(String string, CharSequence2 charSequence2) {
        if (string == null) {
            return true;
        }
        return charSequence2.toString().matches(".*id=" + string + "\\W.*");
    }

    private static ReadLine getReadLine(CharSequence2 charSequence2, File file, String string) {
        try {
            if (string == null) {
                Log.info("Using default charset");
                return new UncommentReadLine(new ReadLineReader(new FileReader(file), file.getAbsolutePath()));
            }
            Log.info("Using charset " + string);
            return new UncommentReadLine(new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), string), file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            return new ReadLineSimple(charSequence2, iOException.toString());
        }
    }

    private static ReadLine getReadLine(CharSequence2 charSequence2, URL uRL, String string) {
        try {
            if (string == null) {
                Log.info("Using default charset");
                return new UncommentReadLine(new ReadLineReader(new InputStreamReader(uRL.openStream()), uRL.toString()));
            }
            Log.info("Using charset " + string);
            return new UncommentReadLine(new ReadLineReader(new InputStreamReader(uRL.openStream(), string), uRL.toString()));
        }
        catch (IOException iOException) {
            return new ReadLineSimple(charSequence2, iOException.toString());
        }
    }

    public static boolean containsStartDiagram(CharSequence2 charSequence2, File file, String string) throws IOException {
        ReadLine readLine = StartDiagramExtractReader.getReadLine(charSequence2, file, string);
        return StartDiagramExtractReader.containsStartDiagram(readLine);
    }

    public static boolean containsStartDiagram(CharSequence2 charSequence2, URL uRL, String string) throws IOException {
        ReadLine readLine = StartDiagramExtractReader.getReadLine(charSequence2, uRL, string);
        return StartDiagramExtractReader.containsStartDiagram(readLine);
    }

    private static boolean containsStartDiagram(ReadLine readLine) throws IOException {
        try {
            CharSequence2 charSequence2 = null;
            while ((charSequence2 = readLine.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(charSequence2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (readLine != null) {
                readLine.close();
            }
        }
        return false;
    }

    public CharSequence2 readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        CharSequence2 charSequence2 = this.raw.readLine();
        if (charSequence2 != null && StartUtils.isArobaseEndDiagram(charSequence2)) {
            this.finished = true;
            return null;
        }
        return charSequence2;
    }

    public void close() throws IOException {
        this.raw.close();
    }
}

