/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class UncommentReadLine
implements ReadLine {
    private final ReadLine raw;
    private final Pattern2 start;
    private final Pattern2 unpause;
    private String headerToRemove;
    private boolean paused;

    public UncommentReadLine(ReadLine readLine) {
        this.raw = readLine;
        this.start = MyPattern.cmpile("(?i)((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start");
        this.unpause = MyPattern.cmpile("(?i)((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause");
    }

    public CharSequence2 readLine() throws IOException {
        Matcher2 matcher2;
        CharSequence2 charSequence2 = this.raw.readLine();
        if (charSequence2 == null) {
            return null;
        }
        String string = StartUtils.beforeStartUml(charSequence2);
        if (string != null) {
            this.headerToRemove = string;
        }
        if (this.paused && (matcher2 = this.unpause.matcher(charSequence2)).find()) {
            this.headerToRemove = matcher2.group(1);
        }
        if (this.headerToRemove != null && this.headerToRemove.startsWith(charSequence2.toString2())) {
            return new CharSequence2Impl("", charSequence2.getLocation());
        }
        if (this.headerToRemove != null && charSequence2.toString2().startsWith(this.headerToRemove)) {
            return charSequence2.subSequence(this.headerToRemove.length(), charSequence2.length());
        }
        return charSequence2;
    }

    public void close() throws IOException {
        this.raw.close();
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }
}

