/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Month {
    JANUARY(31),
    FEBRUARY(28),
    MARCH(31),
    APRIL(30),
    MAY(31),
    JUNE(30),
    JULY(31),
    AUGUST(31),
    SEPTEMBER(30),
    OCTOBER(31),
    NOVEMBER(30),
    DECEMBER(31);

    private final int daysPerMonth;

    private Month(int n2) {
        this.daysPerMonth = n2;
    }

    public static String getRegexString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Month month : Month.values()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(month.name().substring(0, 3) + "[a-z]*");
        }
        return stringBuilder.toString();
    }

    public static Month fromString(String string) {
        string = StringUtils.goUpperCase(string).substring(0, 3);
        for (Month month : Month.values()) {
            if (!month.name().startsWith(string)) continue;
            return month;
        }
        throw new IllegalArgumentException();
    }

    public final int getDaysPerMonth(int n) {
        if (this == FEBRUARY && n % 4 == 0) {
            return 29;
        }
        return this.daysPerMonth;
    }

    public Month next() {
        return Month.values()[(this.ordinal() + 1) % 12];
    }

    public int m() {
        return 3 + (this.ordinal() + 10) % 12;
    }
}

