/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDraw
implements UDrawable {
    private final Task task;
    private final TimeScale timeScale;
    private final double y;
    private ComplementColors colors;
    private final double margin = 2.0;

    public TaskDraw(Task task, TimeScale timeScale, double d) {
        this.y = d;
        this.task = task;
        this.timeScale = timeScale;
    }

    public TextBlock getTitle() {
        return this.task.getCode().getSimpleDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont uFont = UFont.serif(11);
        return new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
    }

    public void drawU(UGraphic uGraphic) {
        double d = this.timeScale.getStartingPosition(this.task.getStart());
        UShape uShape = this.getShape();
        uGraphic = this.applyColors(uGraphic);
        uGraphic.apply(new UTranslate(d + 2.0, 2.0)).draw(uShape);
    }

    private UGraphic applyColors(UGraphic uGraphic) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(uGraphic);
        }
        if (this.isDiamond()) {
            return uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        }
        return uGraphic.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(HtmlColorUtils.COL_84BE84));
    }

    private UShape getShape() {
        if (this.isDiamond()) {
            return this.getDiamond();
        }
        Instant instant = this.task.getStart();
        Instant instant2 = this.task.getEnd();
        double d = this.timeScale.getStartingPosition(instant);
        double d2 = this.timeScale.getStartingPosition(instant2.increment());
        return new URectangle(d2 - d - 4.0, this.getHeight() - 4.0, 8.0, 8.0);
    }

    private boolean isDiamond() {
        Instant instant;
        Instant instant2 = this.task.getStart();
        return instant2.compareTo(instant = this.task.getEnd()) == 0;
    }

    private UShape getDiamond() {
        double d = this.getHeight() - 4.0;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(d / 2.0, 0.0);
        uPolygon.addPoint(d, d / 2.0);
        uPolygon.addPoint(d / 2.0, d);
        uPolygon.addPoint(0.0, d / 2.0);
        return uPolygon;
    }

    public double getHeight() {
        return 16.0;
    }

    public double getY() {
        return this.y;
    }

    public double getY(Direction direction) {
        if (direction == Direction.UP) {
            return this.y;
        }
        if (direction == Direction.DOWN) {
            return this.y + this.getHeight();
        }
        return this.y + this.getHeight() / 2.0;
    }

    public void setColors(ComplementColors complementColors) {
        this.colors = complementColors;
    }
}

