/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementBeforeOrAfterOrAtTaskStartOrEnd;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.GanttConstraint;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.TaskInstant;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbStarts
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementBeforeOrAfterOrAtTaskStartOrEnd());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("starts");
    }

    @Override
    public Verb getVerb(final GanttDiagram ganttDiagram, RegexResult regexResult) {
        return new Verb(){

            public CommandExecutionResult execute(Subject subject, Complement complement) {
                Task task = (Task)subject;
                TaskInstant taskInstant = (TaskInstant)complement;
                task.setStart(taskInstant.getInstantPrecise());
                ganttDiagram.addContraint(new GanttConstraint(taskInstant, new TaskInstant(task, TaskAttribute.START)));
                return CommandExecutionResult.ok();
            }
        };
    }
}

