/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.real.AbstractReal;
import net.sourceforge.plantuml.real.PositiveForce;
import net.sourceforge.plantuml.real.Real;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RealLine {
    private final List<PositiveForce> forces = new ArrayList<PositiveForce>();
    private double min;
    private double max;
    private Set<AbstractReal> all = new HashSet<AbstractReal>();
    private static int CPT;

    RealLine() {
    }

    void register(double d) {
    }

    void register2(AbstractReal abstractReal) {
        this.all.add(abstractReal);
    }

    public double getAbsoluteMin() {
        return this.min;
    }

    public double getAbsoluteMax() {
        return this.max;
    }

    public void addForce(PositiveForce positiveForce) {
        this.forces.add(positiveForce);
    }

    public void compile() {
        int n = 0;
        HashMap<PositiveForce, Integer> hashMap = new HashMap<PositiveForce, Integer>();
        do {
            boolean bl = true;
            for (PositiveForce object : this.forces) {
                boolean bl2 = object.apply();
                if (!bl2) continue;
                RealLine.incCounter(hashMap, object);
                bl = false;
            }
            if (!bl) continue;
            CPT += n;
            this.min = 0.0;
            this.max = 0.0;
            for (AbstractReal abstractReal : this.all) {
                double d = abstractReal.getCurrentValue();
                if (d > this.max) {
                    this.max = d;
                }
                if (!(d < this.min)) continue;
                this.min = d;
            }
            return;
        } while (++n <= 99999);
        this.printCounter(hashMap);
        throw new IllegalStateException("Inifinite Loop?");
    }

    private void printCounter(Map<PositiveForce, Integer> map) {
        for (PositiveForce object : this.forces) {
            System.err.println("force=" + object);
        }
        for (Map.Entry entry : map.entrySet()) {
            System.err.println("count=" + entry.getValue() + " for " + entry.getKey());
        }
    }

    private static void incCounter(Map<PositiveForce, Integer> map, PositiveForce positiveForce) {
        Integer n = map.get(positiveForce);
        map.put(positiveForce, n == null ? 1 : n + 1);
    }

    Real asMaxAbsolute() {
        return new MaxAbsolute();
    }

    Real asMinAbsolute() {
        return new MinAbsolute();
    }

    abstract class AbstractAbsolute
    implements Real {
        AbstractAbsolute() {
        }

        public void printCreationStackTrace() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Real addFixed(double d) {
            throw new UnsupportedOperationException();
        }

        public Real addAtLeast(double d) {
            throw new UnsupportedOperationException();
        }

        public void ensureBiggerThan(Real real) {
            throw new UnsupportedOperationException();
        }

        public Real getMaxAbsolute() {
            return RealLine.this.asMaxAbsolute();
        }

        public Real getMinAbsolute() {
            return RealLine.this.asMinAbsolute();
        }
    }

    class MinAbsolute
    extends AbstractAbsolute {
        MinAbsolute() {
        }

        public double getCurrentValue() {
            return RealLine.this.min;
        }
    }

    class MaxAbsolute
    extends AbstractAbsolute {
        MaxAbsolute() {
        }

        public double getCurrentValue() {
            return RealLine.this.max;
        }
    }
}

