/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.real.AbstractReal;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealDelta;
import net.sourceforge.plantuml.real.RealLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RealMax
extends AbstractReal
implements Real {
    private final List<Real> all = new ArrayList<Real>();
    private final Throwable creationPoint;

    RealMax(Collection<Real> collection) {
        super(RealMax.line(collection));
        this.all.addAll(collection);
        this.creationPoint = new Throwable();
        this.creationPoint.fillInStackTrace();
    }

    static RealLine line(Collection<Real> collection) {
        return ((AbstractReal)collection.iterator().next()).getLine();
    }

    @Override
    public String getName() {
        return "max " + this.all;
    }

    @Override
    double getCurrentValueInternal() {
        double d = this.all.get(0).getCurrentValue();
        for (int i = 1; i < this.all.size(); ++i) {
            Throwable throwable = new Throwable();
            throwable.fillInStackTrace();
            int n = throwable.getStackTrace().length;
            if (n > 1000) {
                System.err.println("The faulty RealMax " + this.getName());
                System.err.println("has been created here:");
                this.printCreationStackTrace();
                throw new IllegalStateException("Infinite recursion?");
            }
            double d2 = this.all.get(i).getCurrentValue();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public Real addFixed(double d) {
        return new RealDelta(this, d);
    }

    @Override
    public Real addAtLeast(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureBiggerThan(Real real) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printCreationStackTrace() {
        this.creationPoint.printStackTrace();
    }
}

