/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.salt.Cell;
import net.sourceforge.plantuml.salt.element.Segment;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Grid {
    private final double[] rowsStart;
    private final double[] colsStart;
    private final TableStrategy strategy;
    private final TextBlock title;
    private final Set<Segment> horizontals = new HashSet<Segment>();
    private final Set<Segment> verticals = new HashSet<Segment>();

    public Grid(double[] dArray, double[] dArray2, TableStrategy tableStrategy, TextBlock textBlock) {
        this.title = textBlock;
        this.rowsStart = dArray;
        this.colsStart = dArray2;
        this.strategy = tableStrategy;
        if (tableStrategy == TableStrategy.DRAW_OUTSIDE || tableStrategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE || tableStrategy == TableStrategy.DRAW_ALL) {
            this.addOutside();
        }
    }

    private void addOutside() {
        int n;
        int n2 = this.rowsStart.length;
        int n3 = this.colsStart.length;
        for (n = 0; n < n3 - 1; ++n) {
            this.horizontals.add(new Segment(0, n));
            this.horizontals.add(new Segment(n2 - 1, n));
        }
        for (n = 0; n < n2 - 1; ++n) {
            this.verticals.add(new Segment(n, 0));
            this.verticals.add(new Segment(n, n3 - 1));
        }
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3;
        int n;
        int n2;
        for (Segment object : this.horizontals) {
            n2 = object.getRow();
            n = object.getCol();
            d3 = this.colsStart[n + 1] - this.colsStart[n];
            uGraphic.apply(new UTranslate(d + this.colsStart[n], d2 + this.rowsStart[n2])).draw(new ULine(d3, 0.0));
        }
        for (Segment segment2 : this.verticals) {
            n2 = segment2.getRow();
            n = segment2.getCol();
            d3 = this.rowsStart[n2 + 1] - this.rowsStart[n2];
            uGraphic.apply(new UTranslate(d + this.colsStart[n], d2 + this.rowsStart[n2])).draw(new ULine(0.0, d3));
        }
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
            UGraphic uGraphic2 = uGraphic.apply(new UTranslate(d + 6.0, d2 - dimension2D.getHeight() * 0.0));
            uGraphic2.apply(new UChangeBackColor(HtmlColorUtils.WHITE)).apply(new UChangeColor(HtmlColorUtils.WHITE)).draw(new URectangle(dimension2D));
            this.title.drawU(uGraphic2);
        }
    }

    public void addCell(Cell cell2) {
        int n;
        if (this.strategy == TableStrategy.DRAW_NONE || this.strategy == TableStrategy.DRAW_OUTSIDE || this.strategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE) {
            return;
        }
        if (this.strategy == TableStrategy.DRAW_HORIZONTAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (n = cell2.getMinCol(); n <= cell2.getMaxCol(); ++n) {
                this.horizontals.add(new Segment(cell2.getMinRow(), n));
                this.horizontals.add(new Segment(cell2.getMaxRow() + 1, n));
            }
        }
        if (this.strategy == TableStrategy.DRAW_VERTICAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (n = cell2.getMinRow(); n <= cell2.getMaxRow(); ++n) {
                this.verticals.add(new Segment(n, cell2.getMinCol()));
                this.verticals.add(new Segment(n, cell2.getMaxCol() + 1));
            }
        }
    }
}

