/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Skeleton {
    private final List<Entry> entries = new ArrayList<Entry>();

    public void add(double d, double d2) {
        this.entries.add(new Entry(d, d2));
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (i + 1 < this.entries.size() && this.entries.get(i + 1).xpos > entry.xpos) {
                entry.drawRectangle(uGraphic);
            }
            Entry entry2 = null;
            for (int j = 0; j < i; ++j) {
                Entry entry3 = this.entries.get(j);
                if (!(entry3.xpos < entry.xpos)) continue;
                entry2 = entry3;
            }
            if (entry2 == null) continue;
            this.drawChild(uGraphic, entry2, entry);
        }
    }

    private void drawChild(UGraphic uGraphic, Entry entry, Entry entry2) {
        double d = entry2.ypos - entry.ypos - 2.0;
        uGraphic.apply(new UTranslate(entry.xpos + 1.0, entry.ypos + 3.0)).draw(new ULine(0.0, d));
        double d2 = entry2.xpos - entry.xpos - 2.0;
        uGraphic.apply(new UTranslate(entry.xpos + 1.0, entry2.ypos + 1.0)).draw(new ULine(d2, 0.0));
    }

    static class Entry {
        private final double xpos;
        private final double ypos;

        public Entry(double d, double d2) {
            this.xpos = d;
            this.ypos = d2;
        }

        public void drawRectangle(UGraphic uGraphic) {
            uGraphic.apply(new UTranslate(this.xpos, this.ypos)).draw(new URectangle(2.0, 2.0));
        }
    }
}

