/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrowAndNoteBox
extends Arrow
implements InGroupable {
    private final Arrow arrow;
    private final List<NoteBox> noteBoxes = new ArrayList<NoteBox>();

    public ArrowAndNoteBox(StringBounder stringBounder, Arrow arrow, List<NoteBox> list) {
        super(arrow.getStartingY(), arrow.getSkin(), arrow.getArrowComponent(), arrow.getUrl());
        this.arrow = arrow;
        this.noteBoxes.addAll(list);
        for (NoteBox noteBox : list) {
            double d = arrow.getPreferredHeight(stringBounder);
            double d2 = noteBox.getPreferredHeight(stringBounder);
            double d3 = this.getPreferredHeight(stringBounder);
            double d4 = d3 - d;
            double d5 = d3 - d2;
            if (d4 > 0.0) {
                arrow.pushToDown(d4 / 2.0);
            }
            if (!(d5 > 0.0)) continue;
            noteBox.pushToDown(d5 / 2.0);
        }
    }

    @Override
    public final double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder);
    }

    @Override
    public void setMaxX(double d) {
        super.setMaxX(d);
        this.arrow.setMaxX(d);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        this.arrow.drawU(uGraphic, d, context2D);
        for (NoteBox noteBox : this.noteBoxes) {
            noteBox.drawU(uGraphic, d, context2D);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        double d = this.arrow.getPreferredHeight(stringBounder);
        for (NoteBox noteBox : this.noteBoxes) {
            d = Math.max(d, noteBox.getPreferredHeight(stringBounder));
        }
        return d;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double d = this.arrow.getPreferredWidth(stringBounder);
        double d2 = d = Math.max(d, this.arrow.getActualWidth(stringBounder));
        for (NoteBox noteBox : this.noteBoxes) {
            d2 += noteBox.getPreferredWidth(stringBounder);
            if (noteBox.getNotePosition() != NotePosition.RIGHT) continue;
            d2 += noteBox.getRightShift(this.arrow.getStartingY());
        }
        return d2;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        double d = this.arrow.getStartingX(stringBounder);
        for (NoteBox noteBox : this.noteBoxes) {
            d = Math.min(d, noteBox.getStartingX(stringBounder));
        }
        return d;
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return this.arrow.getDirection(stringBounder);
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYStartLevel(stringBounder);
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYEndLevel(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition notePosition) {
        return this.arrow.getParticipantAt(stringBounder, notePosition);
    }
}

