/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierComplex;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierStack;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FrontierStackImpl
implements FrontierStack {
    private final List<Stack> all;

    public FrontierStackImpl(double d, int n) {
        Stack stack2 = new Stack(new FrontierComplex(d, n));
        this.all = Collections.singletonList(stack2);
    }

    private FrontierStackImpl(List<Stack> list) {
        this.all = Collections.unmodifiableList(list);
    }

    private FrontierComplex getLast() {
        return this.all.get(this.all.size() - 1).current;
    }

    @Override
    public double getFreeY(ParticipantRange participantRange) {
        return this.getLast().getFreeY(participantRange);
    }

    @Override
    public FrontierStackImpl add(double d, ParticipantRange participantRange) {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack2 = new Stack(this.getLast().add(d, participantRange));
        arrayList.set(arrayList.size() - 1, stack2);
        return new FrontierStackImpl(arrayList);
    }

    @Override
    public FrontierStack openBar() {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack2 = new Stack(this.getLast().copy());
        arrayList.add(stack2);
        return new FrontierStackImpl(arrayList);
    }

    @Override
    public FrontierStack restore() {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack2 = (Stack)arrayList.get(arrayList.size() - 2);
        Stack stack3 = (Stack)arrayList.get(arrayList.size() - 1);
        arrayList.set(arrayList.size() - 2, stack2.addEnvelop(stack3.current));
        arrayList.remove(arrayList.size() - 1);
        Stack stack4 = new Stack(stack2.current.copy());
        arrayList.add(stack4);
        return new FrontierStackImpl(arrayList);
    }

    @Override
    public FrontierStack closeBar() {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack2 = (Stack)arrayList.get(arrayList.size() - 2);
        Stack stack3 = (Stack)arrayList.get(arrayList.size() - 1);
        Stack stack4 = stack2.addEnvelop(stack3.current);
        arrayList.set(arrayList.size() - 2, new Stack(stack4.envelop));
        arrayList.remove(arrayList.size() - 1);
        return new FrontierStackImpl(arrayList);
    }

    public FrontierStackImpl copy() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "nb=" + this.all.size() + " " + this.getLast().toString();
    }

    class Stack {
        private final FrontierComplex current;
        private final FrontierComplex envelop;

        Stack(FrontierComplex frontierComplex) {
            this(frontierComplex, null);
        }

        private Stack(FrontierComplex frontierComplex, FrontierComplex frontierComplex2) {
            this.current = frontierComplex;
            this.envelop = frontierComplex2;
        }

        Stack addEnvelop(FrontierComplex frontierComplex) {
            if (this.envelop == null) {
                return new Stack(this.current, frontierComplex);
            }
            return new Stack(this.current, this.envelop.mergeMax(frontierComplex));
        }
    }
}

