/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElement;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupingGraphicalElementHeader
extends GroupingGraphicalElement {
    private final Component comp;
    private double endY;
    private final boolean isParallel;
    private final List<Component> notes = new ArrayList<Component>();

    public GroupingGraphicalElementHeader(double d, Component component, InGroupableList inGroupableList, boolean bl) {
        super(d, inGroupableList);
        this.comp = component;
        this.isParallel = bl;
    }

    public String toString() {
        return super.toString() + " " + (this.getInGroupableList() == null ? "no" : this.getInGroupableList().toString());
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.comp.getPreferredWidth(stringBounder);
        for (Component component : this.notes) {
            Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
            d += dimension2D.getWidth();
        }
        return d + 5.0;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        if (this.isParallel) {
            return;
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d2 = this.getInGroupableList().getMinX(stringBounder);
        double d3 = this.getInGroupableList().getMaxX(stringBounder) - this.getInGroupableList().getHack2();
        uGraphic = uGraphic.apply(new UTranslate(d2, this.getStartingY()));
        double d4 = this.comp.getPreferredHeight(stringBounder);
        if (!(this.endY > 0.0)) {
            return;
        }
        d4 = this.endY - this.getStartingY();
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d3 - d2, d4);
        this.comp.drawU(uGraphic, new Area(dimension2DDouble), context2D);
        for (Component component : this.notes) {
            Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
            component.drawU(uGraphic.apply(new UTranslate(d3 - d2, 0.0)), new Area(dimension2D), context2D);
        }
    }

    public void setEndY(double d) {
        this.endY = d;
    }

    public void addNotes(StringBounder stringBounder, Collection<Component> collection) {
        for (Component component : collection) {
            this.notes.add(component);
            this.getInGroupableList().changeHack2(component.getPreferredWidth(stringBounder));
        }
    }
}

