/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stairs {
    private final List<Double> ys = new ArrayList<Double>();
    private final List<Integer> values = new ArrayList<Integer>();
    private final Map<Double, Integer> cache = new HashMap<Double, Integer>();

    public String toString() {
        ArrayList<Double> arrayList = new ArrayList<Double>(this.ys);
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder("[");
        for (Double d : arrayList) {
            stringBuilder.append(d + "=" + this.getValue(d) + " ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void addStep(double d, int n) {
        assert (this.ys.size() == this.values.size());
        if (this.ys.size() > 0) {
            double d2 = this.ys.get(this.ys.size() - 1);
            if (d < d2) {
                throw new IllegalArgumentException();
            }
            if (d2 == d) {
                this.values.set(this.ys.size() - 1, n);
                this.cache.clear();
                return;
            }
        }
        this.ys.add(d);
        this.values.add(n);
        this.cache.clear();
    }

    public int getMaxValue() {
        int n = Integer.MIN_VALUE;
        for (Integer n2 : this.values) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public List<Double> getYs() {
        return Collections.unmodifiableList(this.ys);
    }

    private double getLastY() {
        if (this.ys.size() == 0) {
            return 0.0;
        }
        return this.ys.get(this.ys.size() - 1);
    }

    public int getValue(double d) {
        Integer n = this.cache.get(d);
        if (n == null) {
            n = this.getValueSlow(d);
            this.cache.put(d, n);
        }
        return n;
    }

    private int getValueSlow(double d) {
        int n = Collections.binarySearch(this.ys, d);
        if (n >= 0) {
            return this.values.get(n);
        }
        int n2 = -n - 1;
        if (n2 == 0) {
            return 0;
        }
        return this.values.get(n2 - 1);
    }

    public int getLastValue() {
        int n = this.values.size();
        if (n == 0) {
            return 0;
        }
        return this.values.get(n - 1);
    }
}

