/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.NoteOnMessage;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Step1Abstract {
    private final StringBounder stringBounder;
    private final DrawableSet drawingSet;
    private final AbstractMessage message;
    private Frontier freeY2;
    private ArrowConfiguration config;
    private final List<Component> notes = new ArrayList<Component>();
    private ParticipantRange range;

    Step1Abstract(ParticipantRange participantRange, StringBounder stringBounder, AbstractMessage abstractMessage, DrawableSet drawableSet, Frontier frontier) {
        if (frontier == null) {
            throw new IllegalArgumentException();
        }
        this.range = participantRange;
        this.stringBounder = stringBounder;
        this.message = abstractMessage;
        this.freeY2 = frontier;
        this.drawingSet = drawableSet;
    }

    protected final ParticipantRange getParticipantRange() {
        return this.range;
    }

    abstract Frontier prepareMessage(ConstraintSet var1, InGroupablesStack var2);

    protected final ArrowConfiguration getConfig() {
        return this.config;
    }

    protected final void setConfig(ArrowConfiguration arrowConfiguration) {
        this.config = arrowConfiguration.withThickness(this.drawingSet.getArrowThickness());
    }

    protected final List<Component> getNotes() {
        return this.notes;
    }

    protected final void addNote(Component component) {
        this.notes.add(component);
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected final AbstractMessage getMessage() {
        return this.message;
    }

    protected final DrawableSet getDrawingSet() {
        return this.drawingSet;
    }

    protected final Frontier getFreeY() {
        return this.freeY2;
    }

    protected final void incFreeY(double d) {
        this.freeY2 = this.freeY2.add(d, this.range);
    }

    protected final NoteBox createNoteBox(StringBounder stringBounder, Arrow arrow, Component component, NoteOnMessage noteOnMessage) {
        LivingParticipantBox livingParticipantBox = arrow.getParticipantAt(stringBounder, noteOnMessage.getNotePosition());
        NoteBox noteBox = new NoteBox(arrow.getStartingY(), component, livingParticipantBox, null, noteOnMessage.getNotePosition(), noteOnMessage.getUrlNote());
        if (arrow instanceof MessageSelfArrow && noteOnMessage.getNotePosition() == NotePosition.RIGHT) {
            noteBox.pushToRight(arrow.getPreferredWidth(stringBounder));
        }
        return noteBox;
    }
}

