/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationExoTile
implements TileWithUpdateStairs {
    private final LivingSpace livingSpace;
    private final MessageExo message;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final TileArguments tileArguments;

    public Event getEvent() {
        return this.message;
    }

    public CommunicationExoTile(LivingSpace livingSpace, MessageExo messageExo, Skin skin, ISkinParam iSkinParam, TileArguments tileArguments) {
        this.tileArguments = tileArguments;
        this.livingSpace = livingSpace;
        this.message = messageExo;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.message.getType().getDirection() == -1) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        Component component = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabel());
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getPoint1Value(stringBounder);
        double d2 = this.getPoint2Value(stringBounder);
        int n = this.livingSpace.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
        if (n > 0) {
            if (this.message.getType().isRightBorder()) {
                d += 5.0 * (double)n;
            } else {
                d2 += 5.0 * (double)(n - 2);
            }
        }
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        MessageExoType messageExoType = this.message.getType();
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && messageExoType == MessageExoType.FROM_LEFT) {
            d += 6.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && messageExoType == MessageExoType.TO_LEFT) {
            d += 6.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && messageExoType == MessageExoType.TO_RIGHT) {
            d2 -= 6.0;
        }
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && messageExoType == MessageExoType.FROM_RIGHT) {
            d2 -= 6.0;
        }
        Area area = new Area(d2 - d, dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    private boolean isShortArrow() {
        return this.message.isShortArrow();
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public void addConstraints(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        if (!this.message.getType().isRightBorder()) {
            this.livingSpace.getPosC(stringBounder).ensureBiggerThan(this.tileArguments.getOrigin().addFixed(d));
        }
    }

    public void updateStairs(StringBounder stringBounder, double d) {
        ArrowComponent arrowComponent = (ArrowComponent)this.getComponent(stringBounder);
        Dimension2D dimension2D = arrowComponent.getPreferredDimension(stringBounder);
        double d2 = arrowComponent.getStartPoint(stringBounder, dimension2D).getY();
        this.livingSpace.addStepForLivebox(this.getEvent(), d + d2);
    }

    private Real getPoint1(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder);
        }
        return this.tileArguments.getOrigin();
    }

    private double getPoint1Value(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder).getCurrentValue();
        }
        if (this.isShortArrow()) {
            return this.getPoint2Value(stringBounder) - this.getPreferredWidth(stringBounder);
        }
        return this.tileArguments.getBorder1();
    }

    private double getPoint2Value(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            if (this.isShortArrow()) {
                return this.getPoint1Value(stringBounder) + this.getPreferredWidth(stringBounder);
            }
            return this.tileArguments.getBorder2();
        }
        return this.livingSpace.getPosC(stringBounder).getCurrentValue();
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getPoint1(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        return this.getPoint1(stringBounder).addFixed(d);
    }
}

