/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DividerTile
implements Tile {
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Divider divider;
    private final Real origin;
    private final TileArguments tileArguments;

    public Event getEvent() {
        return this.divider;
    }

    public DividerTile(Divider divider, TileArguments tileArguments) {
        this.tileArguments = tileArguments;
        this.divider = divider;
        this.skin = tileArguments.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        this.origin = tileArguments.getOrigin();
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.DIVIDER, null, this.skinParam, this.divider.getText());
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Area area = new Area(this.tileArguments.getBorder2() - this.tileArguments.getBorder1() - this.origin.getCurrentValue(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(this.tileArguments.getBorder1(), 0.0));
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.origin;
    }

    public Real getMaxX(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return this.origin.addFixed(dimension2D.getWidth());
    }
}

