/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final Display strings;
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final UFont font;
    private final HtmlColor fontColor;

    public AbstractTextualComponent(LineBreakStrategy lineBreakStrategy, CharSequence charSequence, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, int n, int n2, int n3, ISkinSimple iSkinSimple, UFont uFont, HtmlColor htmlColor) {
        this(lineBreakStrategy, Display.getWithNewlines(charSequence == null ? "" : charSequence.toString()), fontConfiguration, horizontalAlignment, n, n2, n3, iSkinSimple, false, uFont, htmlColor);
    }

    public AbstractTextualComponent(LineBreakStrategy lineBreakStrategy, Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, int n, int n2, int n3, ISkinSimple iSkinSimple, boolean bl, UFont uFont, HtmlColor htmlColor) {
        this.font = fontConfiguration.getFont();
        this.fontColor = fontConfiguration.getColor();
        this.marginX1 = n;
        this.marginX2 = n2;
        this.marginY = n3;
        this.strings = display;
        this.textBlock = display.size() == 1 && display.get(0).length() == 0 ? new TextBlockEmpty() : (bl ? new BodyEnhanced2(display, FontParam.NOTE, iSkinSimple, HorizontalAlignment.LEFT, fontConfiguration) : display.create(fontConfiguration, horizontalAlignment, iSkinSimple, lineBreakStrategy, CreoleMode.FULL, uFont, htmlColor));
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        return dimension2D.getHeight() + (double)(2 * this.marginY);
    }

    protected final Display getLabels() {
        return this.strings;
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HtmlColor getFontColor() {
        return this.fontColor;
    }
}

