/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseArrow
extends AbstractComponentRoseArrow {
    private final HorizontalAlignment messagePosition;
    private final boolean niceArrow;
    public static final double spaceCrossX = 6.0;
    public static final double diamCircle = 8.0;
    public static final double thinCircle = 1.5;

    public ComponentRoseArrow(HtmlColor htmlColor, FontConfiguration fontConfiguration, Display display, ArrowConfiguration arrowConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, HorizontalAlignment horizontalAlignment2, LineBreakStrategy lineBreakStrategy, boolean bl) {
        super(htmlColor, fontConfiguration, display, arrowConfiguration, iSkinSimple, horizontalAlignment2, lineBreakStrategy);
        this.messagePosition = horizontalAlignment;
        this.niceArrow = bl;
    }

    public void drawInternalU(UGraphic uGraphic, Area area) {
        double d;
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        Dimension2D dimension2D = area.getDimensionToUse();
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        uGraphic = uGraphic.apply(new UChangeColor(this.getForegroundColor()));
        ArrowDressing arrowDressing = this.getArrowConfiguration().getDressing1();
        ArrowDressing arrowDressing2 = this.getArrowConfiguration().getDressing2();
        double d2 = 0.0;
        double d3 = dimension2D.getWidth() - 1.0;
        double d4 = d2 + 1.0;
        double d5 = d3 - 1.0;
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE && arrowDressing2.getHead() == ArrowHead.NONE) {
            d3 -= 4.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE && arrowDressing2.getHead() != ArrowHead.NONE) {
            d3 -= 5.5;
        }
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE && arrowDressing.getHead() == ArrowHead.NONE) {
            d2 += 4.0;
            d3 -= 4.0;
        }
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE && arrowDressing.getHead() == ArrowHead.NORMAL) {
            d2 += 9.5;
            d3 -= 9.5;
        }
        this.drawDressing1(uGraphic, d4, arrowDressing, this.getArrowConfiguration().getDecoration1());
        this.drawDressing2(uGraphic, d5, arrowDressing2, this.getArrowConfiguration().getDecoration2());
        if (arrowDressing2.getPart() == ArrowPart.FULL && arrowDressing2.getHead() == ArrowHead.NORMAL) {
            d3 -= (double)(this.getArrowDeltaX() / 2);
        }
        if (arrowDressing.getPart() == ArrowPart.FULL && arrowDressing.getHead() == ArrowHead.NORMAL) {
            d2 += (double)(this.getArrowDeltaX() / 2);
            d3 -= (double)(this.getArrowDeltaX() / 2);
        }
        if (arrowDressing2.getHead() == ArrowHead.CROSSX) {
            d3 -= 12.0;
        }
        if (arrowDressing.getHead() == ArrowHead.CROSSX) {
            d2 += 12.0;
            d3 -= 12.0;
        }
        this.getArrowConfiguration().applyStroke(uGraphic).apply(new UTranslate(d2, n)).draw(new ULine(d3, 0.0));
        ArrowDirection arrowDirection = this.getDirection2();
        if (this.messagePosition == HorizontalAlignment.CENTER) {
            double d6 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = (dimension2D.getWidth() - d6) / 2.0;
        } else if (this.messagePosition == HorizontalAlignment.RIGHT) {
            double d7 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = dimension2D.getWidth() - d7 - (double)this.getMarginX2() - (double)(arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL ? this.getArrowDeltaX() : 0);
        } else {
            d = this.getMarginX1() + (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE || arrowDirection == ArrowDirection.BOTH_DIRECTION ? this.getArrowDeltaX() : 0);
        }
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(d, 0.0)));
    }

    private void drawDressing1(UGraphic uGraphic, double d, ArrowDressing arrowDressing, ArrowDecoration arrowDecoration) {
        AbstractShadowable abstractShadowable;
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        if (arrowDecoration == ArrowDecoration.CIRCLE) {
            abstractShadowable = new UEllipse(8.0, 8.0);
            uGraphic.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor())).apply(new UTranslate(d - 4.0 - 1.5, (double)n - 4.0 - 0.75)).draw(abstractShadowable);
            d += 5.5;
        }
        if (arrowDressing.getHead() == ArrowHead.ASYNC) {
            if (arrowDressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(uGraphic).apply(new UTranslate(d - 1.0, n)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (arrowDressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(uGraphic).apply(new UTranslate(d - 1.0, n)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (arrowDressing.getHead() == ArrowHead.CROSSX) {
            uGraphic = uGraphic.apply(new UStroke(2.0));
            uGraphic.apply(new UTranslate(6.0, n - this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            uGraphic.apply(new UTranslate(6.0, n + this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (arrowDressing.getHead() == ArrowHead.NORMAL) {
            abstractShadowable = this.getPolygonReverse(arrowDressing.getPart(), n);
            uGraphic.apply(new UChangeBackColor(this.getForegroundColor())).apply(new UTranslate(d, 0.0)).draw(abstractShadowable);
        }
    }

    private void drawDressing2(UGraphic uGraphic, double d, ArrowDressing arrowDressing, ArrowDecoration arrowDecoration) {
        AbstractShadowable abstractShadowable;
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        if (arrowDecoration == ArrowDecoration.CIRCLE) {
            uGraphic = uGraphic.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor()));
            abstractShadowable = new UEllipse(8.0, 8.0);
            uGraphic.apply(new UTranslate(d - 4.0 + 1.5, (double)n - 4.0 - 0.75)).draw(abstractShadowable);
            uGraphic = uGraphic.apply(new UStroke());
            d -= 5.5;
        }
        if (arrowDressing.getHead() == ArrowHead.ASYNC) {
            if (arrowDressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(uGraphic).apply(new UTranslate(d, n)).draw(new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (arrowDressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(uGraphic).apply(new UTranslate(d, n)).draw(new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (arrowDressing.getHead() == ArrowHead.CROSSX) {
            uGraphic = uGraphic.apply(new UStroke(2.0));
            uGraphic.apply(new UTranslate(d - 6.0 - (double)this.getArrowDeltaX(), n - this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            uGraphic.apply(new UTranslate(d - 6.0 - (double)this.getArrowDeltaX(), n + this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
            uGraphic = uGraphic.apply(new UStroke());
        } else if (arrowDressing.getHead() == ArrowHead.NORMAL) {
            abstractShadowable = this.getPolygonNormal(arrowDressing.getPart(), n, d);
            uGraphic.apply(new UChangeBackColor(this.getForegroundColor())).draw(abstractShadowable);
        }
    }

    private UPolygon getPolygonNormal(ArrowPart arrowPart, int n, double d) {
        UPolygon uPolygon = new UPolygon();
        if (arrowPart == ArrowPart.TOP_PART) {
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(d, n);
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n);
        } else if (arrowPart == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n + 1);
            uPolygon.addPoint(d, n + 1);
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n + this.getArrowDeltaY() + 1);
        } else {
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(d, n);
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n + this.getArrowDeltaY());
            if (this.niceArrow) {
                uPolygon.addPoint(d - (double)this.getArrowDeltaX() + 4.0, n);
            }
        }
        return uPolygon;
    }

    private UPolygon getPolygonReverse(ArrowPart arrowPart, int n) {
        UPolygon uPolygon = new UPolygon();
        if (arrowPart == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n);
        } else if (arrowPart == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n + 1);
            uPolygon.addPoint(0.0, n + 1);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY() + 1);
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
            if (this.niceArrow) {
                uPolygon.addPoint(this.getArrowDeltaX() - 4, n);
            }
        }
        return uPolygon;
    }

    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
    }

    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    private final ArrowDirection getDirection2() {
        return this.getArrowConfiguration().getArrowDirection();
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + (double)this.getArrowDeltaX();
    }
}

