/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HtmlColor background;
    private final SymbolContext symbolContext;

    public ComponentRoseGroupingHeader(HtmlColor htmlColor, SymbolContext symbolContext, FontConfiguration fontConfiguration, FontConfiguration fontConfiguration2, Display display, ISkinSimple iSkinSimple) {
        super(LineBreakStrategy.NONE, display.get(0), fontConfiguration, HorizontalAlignment.LEFT, 15, 30, 1, iSkinSimple, null, null);
        this.symbolContext = symbolContext;
        this.background = htmlColor;
        if (display.size() == 1 || display.get(1) == null) {
            this.commentTextBlock = null;
        } else {
            Display display2 = Display.getWithNewlines("[" + display.get(1) + "]");
            this.commentTextBlock = display2.create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple);
        }
        if (this.background == null) {
            throw new IllegalArgumentException();
        }
    }

    private double getSuppHeightForComment(StringBounder stringBounder) {
        if (this.commentTextBlock == null) {
            return 0.0;
        }
        double d = this.commentTextBlock.calculateDimension(stringBounder).getHeight();
        if (d > 15.0) {
            return d - 15.0;
        }
        return 0.0;
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d;
        if (this.commentTextBlock == null) {
            d = 0.0;
        } else {
            Dimension2D dimension2D = this.commentTextBlock.calculateDimension(stringBounder);
            d = (double)(this.getMarginX1() + 0) + dimension2D.getWidth();
        }
        return this.getTextWidth(stringBounder) + d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.getSuppHeightForComment(stringBounder);
    }

    protected void drawBackgroundInternalU(UGraphic uGraphic, Area area) {
        if (this.background instanceof HtmlColorTransparent) {
            return;
        }
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic = this.symbolContext.applyStroke(uGraphic).apply(new UChangeColor(this.symbolContext.getForeColor()));
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        uRectangle.setDeltaShadow(this.symbolContext.getDeltaShadow());
        uGraphic.apply(new UChangeBackColor(this.background)).draw(uRectangle);
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic = this.symbolContext.applyStroke(uGraphic).apply(new UChangeColor(this.symbolContext.getForeColor()));
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        uGraphic.draw(uRectangle);
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextWidth(stringBounder);
        int n2 = (int)this.getTextHeight(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        this.symbolContext.applyColors(uGraphic).draw(uPolygon);
        uGraphic = uGraphic.apply(new UStroke());
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
        if (this.commentTextBlock != null) {
            int n3 = this.getMarginX1() + n;
            int n4 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(uGraphic.apply(new UTranslate(n3 + 0, n4)));
        }
    }
}

