/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseReference
extends AbstractTextualComponent {
    private final HtmlColor background;
    private final int cornersize = 10;
    private final TextBlock textHeader;
    private final double heightFooter = 5.0;
    private final double xMargin = 2.0;
    private final HorizontalAlignment position;
    private final SymbolContext symbolContext;

    public ComponentRoseReference(FontConfiguration fontConfiguration, SymbolContext symbolContext, FontConfiguration fontConfiguration2, Display display, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, HtmlColor htmlColor) {
        super(LineBreakStrategy.NONE, display.subList(1, display.size()), fontConfiguration, HorizontalAlignment.LEFT, 4, 4, 4, iSkinSimple, false, null, null);
        this.position = horizontalAlignment;
        this.symbolContext = symbolContext;
        this.background = htmlColor;
        this.textHeader = display.subList(0, 1).create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple);
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        double d;
        Dimension2D dimension2D = area.getDimensionToUse();
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getHeaderWidth(stringBounder);
        int n2 = (int)this.getHeaderHeight(stringBounder);
        URectangle uRectangle = new URectangle(dimension2D.getWidth() - 4.0 - this.symbolContext.getDeltaShadow(), dimension2D.getHeight() - 5.0);
        uRectangle.setDeltaShadow(this.symbolContext.getDeltaShadow());
        uGraphic = this.symbolContext.withBackColor(this.background).apply(uGraphic);
        uGraphic.apply(new UTranslate(2.0, 0.0)).draw(uRectangle);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic = this.symbolContext.apply(uGraphic);
        uGraphic.apply(new UTranslate(2.0, 0.0)).draw(uPolygon);
        uGraphic = uGraphic.apply(new UStroke());
        this.textHeader.drawU(uGraphic.apply(new UTranslate(15.0, 2.0)));
        if (this.position == HorizontalAlignment.CENTER) {
            double d2 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = (dimension2D.getWidth() - d2) / 2.0;
        } else if (this.position == HorizontalAlignment.RIGHT) {
            double d3 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = dimension2D.getWidth() - d3 - (double)this.getMarginX2() - 2.0;
        } else {
            d = (double)this.getMarginX1() + 2.0;
        }
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(d, this.getMarginY() + n2)));
    }

    private double getHeaderHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textHeader.calculateDimension(stringBounder);
        return dimension2D.getHeight() + 2.0;
    }

    private double getHeaderWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textHeader.calculateDimension(stringBounder);
        return dimension2D.getWidth() + 30.0 + 15.0;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.getHeaderHeight(stringBounder) + 5.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), this.getHeaderWidth(stringBounder)) + 4.0 + this.symbolContext.getDeltaShadow();
    }
}

