/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseSelfArrow
extends AbstractComponentRoseArrow {
    private final double arrowWidth = 45.0;
    private final boolean niceArrow;

    public ComponentRoseSelfArrow(HtmlColor htmlColor, FontConfiguration fontConfiguration, Display display, ArrowConfiguration arrowConfiguration, ISkinSimple iSkinSimple, LineBreakStrategy lineBreakStrategy, boolean bl) {
        super(htmlColor, fontConfiguration, display, arrowConfiguration, iSkinSimple, HorizontalAlignment.LEFT, lineBreakStrategy);
        this.niceArrow = bl;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        boolean bl;
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextHeight(stringBounder);
        uGraphic = uGraphic.apply(new UChangeColor(this.getForegroundColor()));
        UGraphic uGraphic2 = this.getArrowConfiguration().applyStroke(uGraphic);
        double d2 = area.getDeltaX1() < 0.0 ? area.getDeltaX1() : 0.0;
        double d3 = area.getDeltaX1() > 0.0 ? -area.getDeltaX1() : 1.0;
        double d4 = d + this.getArrowOnlyHeight(stringBounder);
        UEllipse uEllipse = new UEllipse(8.0, 8.0);
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE) {
            uGraphic2.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor())).apply(new UTranslate(d2 + 1.0 - 4.0 - 1.5, d - 4.0 - 0.75)).draw(uEllipse);
            d2 += 4.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE) {
            uGraphic2.apply(new UStroke(1.5)).apply(new UChangeColor(this.getForegroundColor())).apply(new UTranslate(d3 - 4.0 - 1.5, d4 - 4.0 - 0.75)).draw(uEllipse);
            d3 += 4.0;
        }
        boolean bl2 = bl = this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.CROSSX;
        if (bl) {
            d3 += 12.0;
        }
        double d5 = d4 - d;
        uGraphic2.apply(new UTranslate(d2, d)).draw(new ULine(42.0 - d2, 0.0));
        uGraphic2.apply(new UTranslate(42.0, d)).draw(new ULine(0.0, d5));
        uGraphic2.apply(new UTranslate(d3, d4)).draw(new ULine(42.0 - d3, 0.0));
        if (this.getArrowConfiguration().isAsync()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(uGraphic).apply(new UTranslate(d3, d4)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(uGraphic).apply(new UTranslate(d3, d4)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (bl) {
            uGraphic = uGraphic.apply(new UStroke(2.0));
            uGraphic.apply(new UTranslate(6.0, d - (double)(this.getArrowDeltaX() / 2) + this.getArrowOnlyHeight(stringBounder))).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            uGraphic.apply(new UTranslate(6.0, d + (double)(this.getArrowDeltaX() / 2) + this.getArrowOnlyHeight(stringBounder))).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else {
            UPolygon uPolygon = this.getPolygon(d4);
            uGraphic.apply(new UChangeBackColor(this.getForegroundColor())).apply(new UTranslate(d3, 0.0)).draw(uPolygon);
        }
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), 0.0)));
    }

    private UPolygon getPolygon(double d) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), d - (double)this.getArrowDeltaY());
            uPolygon.addPoint(0.0, d);
            uPolygon.addPoint(this.getArrowDeltaX(), d);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), d);
            uPolygon.addPoint(0.0, d);
            uPolygon.addPoint(this.getArrowDeltaX(), d + (double)this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), d - (double)this.getArrowDeltaY());
            uPolygon.addPoint(0.0, d);
            uPolygon.addPoint(this.getArrowDeltaX(), d + (double)this.getArrowDeltaY());
            if (this.niceArrow) {
                uPolygon.addPoint(this.getArrowDeltaX() - 4, d);
            }
        }
        return uPolygon;
    }

    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)((double)n + this.getArrowOnlyHeight(stringBounder));
        return new Point2D.Double(this.getPaddingX(), (double)n2 + this.getPaddingY());
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 45.0);
    }
}

