/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.stats.ParsedGenerated;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalData {
    private final Preferences prefs;
    private ParsedGenerated current;
    private final List<ParsedGenerated> historical = new ArrayList<ParsedGenerated>();

    HistoricalData(Preferences preferences) {
        this.prefs = preferences;
        try {
            this.historical.addAll(this.reload());
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        Collections.sort(this.historical, this.getIdComparator());
    }

    public void reset() {
        char c = (char)(65 + this.historical.size());
        if (this.historical.size() > 7) {
            ParsedGenerated parsedGenerated = this.historical.get(0);
            String string = parsedGenerated.parsed().getName();
            c = string.charAt("histo.".length());
        }
        this.current = ParsedGenerated.loadDated(this.prefs, "histo." + c);
        this.current.reset();
        long l = this.getMaxId();
        this.current.parsedDated().setComment(Long.toString(l + 1L, 36) + "/" + Version.versionString());
    }

    private long getMaxId() {
        long l = 0L;
        for (ParsedGenerated parsedGenerated : this.historical) {
            l = Math.max(l, parsedGenerated.getId());
        }
        return l;
    }

    private Comparator<? super ParsedGenerated> getIdComparator() {
        return new Comparator<ParsedGenerated>(){

            @Override
            public int compare(ParsedGenerated parsedGenerated, ParsedGenerated parsedGenerated2) {
                long l;
                long l2 = parsedGenerated.getId();
                if (l2 > (l = parsedGenerated2.getId())) {
                    return 1;
                }
                if (l2 < l) {
                    return -1;
                }
                return 0;
            }
        };
    }

    private List<ParsedGenerated> reload() throws BackingStoreException {
        ArrayList<ParsedGenerated> arrayList = new ArrayList<ParsedGenerated>();
        int n = "histo.".length();
        for (String string : this.prefs.keys()) {
            if (!string.startsWith("histo.") || !string.endsWith(".p.saved")) continue;
            String string2 = string.substring(n, n + 1);
            ParsedGenerated parsedGenerated = ParsedGenerated.loadDated(this.prefs, "histo." + string2);
            arrayList.add(parsedGenerated);
        }
        return arrayList;
    }

    public ParsedGenerated current() {
        return this.current;
    }

    public List<ParsedGenerated> getHistorical() {
        return Collections.unmodifiableList(this.historical);
    }
}

