/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.stats.FormatCounter;
import net.sourceforge.plantuml.stats.HistoricalData;
import net.sourceforge.plantuml.stats.HtmlConverter;
import net.sourceforge.plantuml.stats.ParsedGenerated;
import net.sourceforge.plantuml.stats.StatsImpl;
import net.sourceforge.plantuml.stats.TextConverter;
import net.sourceforge.plantuml.stats.XmlConverter;
import net.sourceforge.plantuml.stats.api.Stats;

public class StatsUtils {
    static final Preferences prefs = Preferences.userNodeForPackage(StatsUtils.class);
    static ParsedGenerated fullEver;
    static ConcurrentMap<String, ParsedGenerated> byTypeEver;
    static ConcurrentMap<String, ParsedGenerated> byTypeCurrent;
    static FormatCounter formatCounterCurrent;
    static FormatCounter formatCounterEver;
    static HistoricalData historicalData;
    static boolean xmlStats;
    static boolean htmlStats;
    static boolean realTimeStats;
    private static final int VERSION = 14;

    public static Stats getStats() {
        return new StatsImpl(byTypeEver, byTypeCurrent, formatCounterCurrent, formatCounterEver, historicalData, fullEver);
    }

    private static void restoreNow() {
        try {
            prefs.sync();
            fullEver = ParsedGenerated.loadDated(prefs, "full");
            historicalData = new HistoricalData(prefs);
            StatsUtils.reload();
            formatCounterEver.reload("format.", prefs);
        }
        catch (BackingStoreException backingStoreException) {
            Log.error("Error reloading stats " + backingStoreException);
            byTypeEver.clear();
        }
    }

    private static void reload() throws BackingStoreException {
        for (String string : prefs.keys()) {
            String string2;
            ParsedGenerated parsedGenerated;
            if (!string.startsWith("type.") || !string.endsWith(".p.saved") || (parsedGenerated = ParsedGenerated.loadDated(prefs, string2 = StatsUtils.removeDotPSaved(string))) == null) continue;
            byTypeEver.put(string2.substring("type.".length()), parsedGenerated);
        }
    }

    static String removeDotPSaved(String string) {
        return string.substring(0, string.length() - ".p.saved".length());
    }

    private static void endingHook() {
        try {
            Stats stats = StatsUtils.getStatsLazzy();
            if (xmlStats) {
                StatsUtils.xmlOutput(stats);
            }
            if (htmlStats) {
                StatsUtils.htmlOutput(stats);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static Stats getStatsLazzy() {
        if (xmlStats || htmlStats) {
            return StatsUtils.getStats();
        }
        return null;
    }

    static void htmlOutput(Stats stats) throws FileNotFoundException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter("plantuml-stats.html");
            printWriter.print(new HtmlConverter(stats).toHtml());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static void xmlOutput(Stats stats) throws FileNotFoundException, TransformerException, ParserConfigurationException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream("plantuml-stats.xml");
            new XmlConverter(stats).createXml(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public static void setXmlStats(boolean bl) {
        xmlStats = bl;
    }

    public static void setHtmlStats(boolean bl) {
        htmlStats = bl;
    }

    public static void setRealTimeStats(boolean bl) {
        realTimeStats = bl;
    }

    public static void outHtml() throws FileNotFoundException {
        StatsUtils.htmlOutput(StatsUtils.getStats());
    }

    public static void dumpStats() {
        new TextConverter(StatsUtils.getStats()).printMe(System.out);
    }

    public static void loopStats() throws InterruptedException {
        int n = 0;
        while (true) {
            StatsUtils.restoreNow();
            StatsUtils.clearScreen(System.out, n);
            TextConverter textConverter = new TextConverter(StatsUtils.getStats());
            textConverter.printMe(System.out);
            n = textConverter.getLinesUsed();
            Thread.sleep(3000L);
        }
    }

    private static void clearScreen(PrintStream printStream, int n) {
        if (n == 0) {
            return;
        }
        if (File.separatorChar == '/') {
            System.out.println(String.format("\u001b[%dA", n + 1));
        } else {
            for (int i = 0; i < 20; ++i) {
                printStream.println();
            }
        }
    }

    static {
        byTypeEver = new ConcurrentHashMap<String, ParsedGenerated>();
        byTypeCurrent = new ConcurrentHashMap<String, ParsedGenerated>();
        formatCounterCurrent = new FormatCounter("currentformat.");
        formatCounterEver = new FormatCounter("format.");
        xmlStats = false;
        htmlStats = false;
        realTimeStats = false;
        try {
            Logger.getLogger("java.util.prefs").setFilter(new Filter(){

                public boolean isLoggable(LogRecord logRecord) {
                    String string = logRecord.getMessage();
                    System.err.println("SPECIAL TRACE FOR PLANTUML: " + string);
                    return false;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (prefs.getInt("VERSION", 0) != 14) {
            try {
                prefs.clear();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
            prefs.putInt("VERSION", 14);
        }
        StatsUtils.restoreNow();
        if (historicalData != null) {
            historicalData.reset();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                StatsUtils.endingHook();
            }
        });
    }
}

