/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.suggest;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;

public class SuggestEngineResult {
    private final SuggestEngineStatus status;
    private final String suggestedLine;
    public static final SuggestEngineResult CANNOT_CORRECT = new SuggestEngineResult(SuggestEngineStatus.CANNOT_CORRECT);
    public static final SuggestEngineResult SYNTAX_OK = new SuggestEngineResult(SuggestEngineStatus.SYNTAX_OK);

    private SuggestEngineResult(SuggestEngineStatus suggestEngineStatus) {
        if (suggestEngineStatus == SuggestEngineStatus.ONE_SUGGESTION) {
            throw new IllegalArgumentException();
        }
        this.status = suggestEngineStatus;
        this.suggestedLine = null;
    }

    public String toString() {
        return (Object)((Object)this.status) + " " + this.suggestedLine;
    }

    public int hashCode() {
        return this.status.hashCode() + (this.suggestedLine == null ? 0 : this.suggestedLine.hashCode());
    }

    public boolean equals(Object object) {
        SuggestEngineResult suggestEngineResult = (SuggestEngineResult)object;
        return this.status.equals((Object)suggestEngineResult.status) && SuggestEngineResult.sameString(this.suggestedLine, suggestEngineResult.suggestedLine);
    }

    private static boolean sameString(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null || string2 != null) {
            return false;
        }
        return string.equals(string2);
    }

    public SuggestEngineResult(String string) {
        if (StringUtils.trin(string).length() == 0) {
            throw new IllegalArgumentException();
        }
        this.status = SuggestEngineStatus.ONE_SUGGESTION;
        this.suggestedLine = string;
    }

    public final SuggestEngineStatus getStatus() {
        return this.status;
    }

    public final String getSuggestedLine() {
        return this.suggestedLine;
    }
}

