/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersions;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.vizjs.GraphvizJs;
import net.sourceforge.plantuml.vizjs.GraphvizJsRuntimeException;

public class DotStringFactory
implements Moveable {
    private final Bibliotekon bibliotekon = new Bibliotekon();
    private final Set<String> rankMin = new HashSet<String>();
    private final ColorSequence colorSequence;
    private final Cluster root;
    private Cluster current;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final DotMode dotMode;
    private final StringBounder stringBounder;
    private GraphvizVersion graphvizVersion;

    public DotStringFactory(StringBounder stringBounder, DotData dotData) {
        this.skinParam = dotData.getSkinParam();
        this.umlDiagramType = dotData.getUmlDiagramType();
        this.dotMode = dotData.getDotMode();
        this.colorSequence = new ColorSequence();
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(this.colorSequence, this.skinParam, dotData.getRootGroup());
    }

    public DotStringFactory(StringBounder stringBounder, CucaDiagram cucaDiagram) {
        this.skinParam = cucaDiagram.getSkinParam();
        this.umlDiagramType = cucaDiagram.getUmlDiagramType();
        this.dotMode = DotMode.NORMAL;
        this.colorSequence = new ColorSequence();
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(this.colorSequence, this.skinParam, cucaDiagram.getEntityFactory().getRootGroup());
    }

    public void addShape(Shape shape) {
        this.current.addShape(shape);
    }

    private void printMinRanking(StringBuilder stringBuilder) {
        if (this.rankMin.size() == 0) {
            return;
        }
        stringBuilder.append("{ rank = min;");
        for (String string : this.rankMin) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        stringBuilder.append("}");
    }

    private double getHorizontalDzeta() {
        double d = 0.0;
        for (Line line : this.bibliotekon.allLines()) {
            double d2 = line.getHorizontalDzeta(this.stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d / 10.0;
    }

    private double getVerticalDzeta() {
        double d = 0.0;
        for (Line line : this.bibliotekon.allLines()) {
            double d2 = line.getVerticalDzeta(this.stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d / 10.0;
    }

    String createDotString(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        double d = this.getHorizontalDzeta();
        if (d < (double)this.getMinNodeSep()) {
            d = this.getMinNodeSep();
        }
        if (this.skinParam.getNodesep() != 0.0) {
            d = this.skinParam.getNodesep();
        }
        String string = SvekUtils.pixelToInches(d);
        double d2 = this.getVerticalDzeta();
        if (d2 < (double)this.getMinRankSep()) {
            d2 = this.getMinRankSep();
        }
        if (this.skinParam.getRanksep() != 0.0) {
            d2 = this.skinParam.getRanksep();
        }
        String string2 = SvekUtils.pixelToInches(d2);
        stringBuilder.append("digraph unix {");
        SvekUtils.println(stringBuilder);
        for (String string3 : stringArray) {
            if (string3.startsWith("ranksep")) {
                stringBuilder.append("ranksep=" + string2 + ";");
            } else if (string3.startsWith("nodesep")) {
                stringBuilder.append("nodesep=" + string + ";");
            } else {
                stringBuilder.append(string3);
            }
            SvekUtils.println(stringBuilder);
        }
        stringBuilder.append("remincross=true;");
        SvekUtils.println(stringBuilder);
        stringBuilder.append("searchsize=500;");
        SvekUtils.println(stringBuilder);
        DotSplines dotSplines = this.skinParam.getDotSplines();
        if (dotSplines == DotSplines.POLYLINE) {
            stringBuilder.append("splines=polyline;");
            SvekUtils.println(stringBuilder);
        } else if (dotSplines == DotSplines.ORTHO) {
            stringBuilder.append("splines=ortho;");
            SvekUtils.println(stringBuilder);
        }
        if (this.skinParam.getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            stringBuilder.append("rankdir=LR;");
            SvekUtils.println(stringBuilder);
        }
        this.manageMinMaxCluster(stringBuilder);
        this.root.printCluster1(stringBuilder, this.bibliotekon.allLines(), this.stringBounder);
        for (Line line : this.bibliotekon.lines0()) {
            line.appendLine(this.getGraphvizVersion(), stringBuilder, this.dotMode);
        }
        this.root.fillRankMin(this.rankMin);
        this.root.printCluster2(stringBuilder, this.bibliotekon.allLines(), this.stringBounder, this.dotMode, this.getGraphvizVersion(), this.umlDiagramType);
        this.printMinRanking(stringBuilder);
        for (Line line : this.bibliotekon.lines1()) {
            line.appendLine(this.getGraphvizVersion(), stringBuilder, this.dotMode);
        }
        SvekUtils.println(stringBuilder);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void manageMinMaxCluster(StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Cluster object : this.bibliotekon.allCluster()) {
            String string;
            String string2 = object.getMinPoint(this.umlDiagramType);
            if (string2 != null) {
                arrayList.add(string2);
            }
            if ((string = object.getMaxPoint(this.umlDiagramType)) == null) continue;
            arrayList2.add(string);
        }
        if (arrayList.size() > 0) {
            stringBuilder.append("{rank=min;");
            for (String string : arrayList) {
                stringBuilder.append(string);
                stringBuilder.append(" [shape=point,width=.01,label=\"\"]");
                stringBuilder.append(";");
            }
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
        }
        if (arrayList2.size() > 0) {
            stringBuilder.append("{rank=max;");
            for (String string : arrayList2) {
                stringBuilder.append(string);
                stringBuilder.append(" [shape=point,width=.01,label=\"\"]");
                stringBuilder.append(";");
            }
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
        }
    }

    private int getMinRankSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 40;
        }
        return 60;
    }

    private int getMinNodeSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 20;
        }
        return 35;
    }

    public GraphvizVersion getGraphvizVersion() {
        if (this.graphvizVersion == null) {
            this.graphvizVersion = this.getGraphvizVersionInternal();
        }
        return this.graphvizVersion;
    }

    private GraphvizVersion getGraphvizVersionInternal() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "foo;", "svg");
        if (graphviz instanceof GraphvizJs) {
            return GraphvizJs.getGraphvizVersion(false);
        }
        File file = graphviz.getDotExe();
        return GraphvizVersions.getInstance().getVersion(file);
    }

    public String getSvg(BaseFile baseFile, String[] stringArray) throws IOException {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream;
        block5: {
            Object object3;
            String string = this.createDotString(stringArray);
            if (baseFile != null) {
                object3 = baseFile.getTraceFile("svek.dot");
                SvekUtils.traceString((File)object3, string);
            }
            object3 = GraphvizUtils.create(this.skinParam, string, "svg");
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object2 = object3.createFile3(byteArrayOutputStream);
                byteArrayOutputStream.close();
                if (((ProcessState)object2).differs(ProcessState.TERMINATED_OK())) {
                    throw new IllegalStateException("Timeout4 " + object2, ((ProcessState)object2).getCause());
                }
            }
            catch (GraphvizJsRuntimeException graphvizJsRuntimeException) {
                System.err.println("GraphvizJsRuntimeException");
                this.graphvizVersion = GraphvizJs.getGraphvizVersion(true);
                string = this.createDotString(stringArray);
                object3 = GraphvizUtils.create(this.skinParam, string, "svg");
                byteArrayOutputStream = new ByteArrayOutputStream();
                object = object3.createFile3(byteArrayOutputStream);
                byteArrayOutputStream.close();
                if (!((ProcessState)object).differs(ProcessState.TERMINATED_OK())) break block5;
                throw new IllegalStateException("Timeout4 " + object, ((ProcessState)object).getCause());
            }
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = new String((byte[])object2, "UTF-8");
        if (baseFile != null) {
            File file = baseFile.getTraceFile("svek.svg");
            SvekUtils.traceString(file, (String)object);
        }
        return object;
    }

    public boolean illegalDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        if (graphviz instanceof GraphvizJs) {
            return false;
        }
        File file = graphviz.getDotExe();
        return file == null || !file.isFile() || !file.canRead();
    }

    public File getDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        return graphviz.getDotExe();
    }

    public ClusterPosition solve(String string) throws IOException, InterruptedException {
        double d;
        double d2;
        int n;
        if (string.length() == 0) {
            throw new EmptySvgException();
        }
        Pattern pattern = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        int n2 = Integer.parseInt(matcher.group(1));
        int n3 = Integer.parseInt(matcher.group(2));
        MinFinder minFinder = new MinFinder();
        for (Shape moveable : this.bibliotekon.allShapes()) {
            double d3;
            double d4;
            n = string.indexOf("<title>" + moveable.getUid() + "</title>");
            if (moveable.getType() == ShapeType.RECTANGLE || moveable.getType() == ShapeType.RECTANGLE_HTML_FOR_PORTS || moveable.getType() == ShapeType.FOLDER || moveable.getType() == ShapeType.DIAMOND) {
                List<Point2D.Double> list = SvekUtils.extractPointsList(string, n, n3);
                d2 = SvekUtils.getMinX(list);
                d = SvekUtils.getMinY(list);
                minFinder.manage(d2, d);
                moveable.moveSvek(d2, d);
                continue;
            }
            if (moveable.getType() == ShapeType.ROUND_RECTANGLE) {
                List<Point2D.Double> list;
                int n4 = string.indexOf("d=\"", n + 1);
                n = string.indexOf("points=\"", n + 1);
                if (n4 != -1 && (n == -1 || n4 < n)) {
                    list = SvekUtils.extractD(string, n4, n3);
                } else {
                    list = SvekUtils.extractPointsList(string, n, n3);
                    for (int i = 0; i < 3; ++i) {
                        n = string.indexOf("points=\"", n + 1);
                        list.addAll(SvekUtils.extractPointsList(string, n, n3));
                    }
                }
                d4 = SvekUtils.getMinX(list);
                d3 = SvekUtils.getMinY(list);
                minFinder.manage(d4, d3);
                moveable.moveSvek(d4, d3);
                continue;
            }
            if (moveable.getType() == ShapeType.OCTAGON) {
                n = string.indexOf("points=\"", n + 1);
                List<Point2D.Double> list = SvekUtils.extractPointsList(string, n, n3);
                d2 = SvekUtils.getMinX(list);
                d = SvekUtils.getMinY(list);
                minFinder.manage(d2, d);
                moveable.moveSvek(d2, d);
                moveable.setOctagon(d2, d, list);
                continue;
            }
            if (moveable.getType() == ShapeType.CIRCLE || moveable.getType() == ShapeType.CIRCLE_IN_RECT || moveable.getType() == ShapeType.OVAL) {
                double d5 = SvekUtils.getValue(string, n, "cx");
                d4 = SvekUtils.getValue(string, n, "cy") + (double)n3;
                d3 = SvekUtils.getValue(string, n, "rx");
                double d6 = SvekUtils.getValue(string, n, "ry");
                moveable.moveSvek(d5 - d3, d4 - d6);
                continue;
            }
            throw new IllegalStateException(moveable.getType().toString() + " " + moveable.getUid());
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            n = this.getClusterIndex(string, cluster.getColor());
            List<Point2D.Double> list = SvekUtils.extractPointsList(string, n, n3);
            d2 = SvekUtils.getMinX(list);
            d = SvekUtils.getMinY(list);
            double d7 = SvekUtils.getMaxX(list);
            double d8 = SvekUtils.getMaxY(list);
            cluster.setPosition(d2, d, d7, d8);
            minFinder.manage(d2, d);
            if (cluster.getTitleAndAttributeWidth() == 0 || cluster.getTitleAndAttributeHeight() == 0) continue;
            n = this.getClusterIndex(string, cluster.getTitleColor());
            List<Point2D.Double> list2 = SvekUtils.extractPointsList(string, n, n3);
            double d9 = SvekUtils.getMinX(list2);
            double d10 = SvekUtils.getMinY(list2);
            cluster.setTitlePosition(d9, d10);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.solveLine(string, n3, minFinder);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.manageCollision(this.bibliotekon.allShapes());
        }
        minFinder.manage(0.0, 0.0);
        return new ClusterPosition(minFinder.getMinX(), minFinder.getMinY(), n2, n3);
    }

    private int getClusterIndex(String string, int n) {
        String string2 = StringUtils.goLowerCase(StringUtils.getAsHtml(n));
        String string3 = "=\"" + string2 + "\"";
        int n2 = string.indexOf(string3);
        if (n2 == -1) {
            String string4 = "stroke:" + string2 + ";";
            n2 = string.indexOf(string4);
        }
        if (n2 == -1) {
            throw new IllegalStateException("Cannot find color " + string2);
        }
        return n2;
    }

    public void openCluster(IGroup iGroup, int n, int n2, TextBlock textBlock, TextBlock textBlock2) {
        this.current = this.current.createChild(iGroup, n, n2, textBlock, textBlock2, this.colorSequence, this.skinParam);
        this.bibliotekon.addCluster(this.current);
    }

    public void closeCluster() {
        if (this.current.getParent() == null) {
            throw new IllegalStateException();
        }
        this.current = this.current.getParent();
    }

    public void moveSvek(double d, double d2) {
        for (Shape moveable : this.bibliotekon.allShapes()) {
            moveable.moveSvek(d, d2);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.moveSvek(d, d2);
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            cluster.moveSvek(d, d2);
        }
    }

    public final Bibliotekon getBibliotekon() {
        return this.bibliotekon;
    }

    public ColorSequence getColorSequence() {
        return this.colorSequence;
    }
}

