/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class InnerStateAutonom
extends AbstractTextBlock
implements IEntityImage {
    private final IEntityImage im;
    private final TextBlock title;
    private final TextBlockWidth attribute;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final boolean shadowing;
    private final Url url;
    private final boolean withSymbol;
    private final UStroke stroke;

    public InnerStateAutonom(IEntityImage iEntityImage, TextBlock textBlock, TextBlockWidth textBlockWidth, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, Url url, boolean bl2, UStroke uStroke) {
        this.im = iEntityImage;
        this.withSymbol = bl2;
        this.title = textBlock;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.shadowing = bl;
        this.attribute = textBlockWidth;
        this.url = url;
        this.stroke = uStroke;
    }

    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D2 = this.attribute.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D3 = this.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D2.getHeight() > 0.0 ? 5.0 : 0.0;
        double d2 = 5.0 + dimension2D.getHeight() + 5.0;
        RoundedContainer roundedContainer = new RoundedContainer(dimension2D3, d2, dimension2D2.getHeight() + d, this.borderColor, this.backColor, this.im.getBackcolor(), this.stroke);
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        roundedContainer.drawU(uGraphic, this.shadowing);
        this.title.drawU(uGraphic.apply(new UTranslate((dimension2D3.getWidth() - dimension2D.getWidth()) / 2.0, 5.0)));
        this.attribute.asTextBlock(dimension2D3.getWidth()).drawU(uGraphic.apply(new UTranslate(5.0, 5.0 + dimension2D.getHeight() + 5.0)));
        double d3 = this.getSpaceYforURL(uGraphic.getStringBounder());
        this.im.drawU(uGraphic.apply(new UTranslate(5.0, d3)));
        if (this.withSymbol) {
            EntityImageState.drawSymbol(uGraphic.apply(new UChangeColor(this.borderColor)), dimension2D3.getWidth(), dimension2D3.getHeight());
        }
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private double getSpaceYforURL(StringBounder stringBounder) {
        Dimension2D dimension2D = this.title.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.attribute.calculateDimension(stringBounder);
        double d = dimension2D2.getHeight() > 0.0 ? 5.0 : 0.0;
        double d2 = 5.0 + dimension2D.getHeight() + 5.0;
        double d3 = d2 + d + dimension2D2.getHeight();
        return d3 + 5.0;
    }

    public HtmlColor getBackcolor() {
        return null;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.title.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.attribute.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = Dimension2DDouble.mergeTB(dimension2D2, dimension2D3, dimension2D);
        double d = dimension2D3.getHeight() > 0.0 ? 5.0 : 0.0;
        Dimension2D dimension2D5 = Dimension2DDouble.delta(dimension2D4, 20.0 + d);
        return dimension2D5;
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    public boolean isHidden() {
        return this.im.isHidden();
    }
}

