/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPort;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockArrow;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.svek.ArithmeticStrategySum;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Oscillator;
import net.sourceforge.plantuml.svek.PointAndAngle;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.Side;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtends;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Moveable,
Hideable {
    private final Cluster ltail;
    private final Cluster lhead;
    private final Link link;
    private final EntityPort startUid;
    private final EntityPort endUid;
    private final TextBlock startTailText;
    private final TextBlock endHeadText;
    private final TextBlock labelText;
    private boolean divideLabelWidthByTwo = false;
    private final int lineColor;
    private final int noteLabelColor;
    private final int startTailColor;
    private final int endHeadColor;
    private final StringBounder stringBounder;
    private final Bibliotekon bibliotekon;
    private DotPath dotPath;
    private Positionable startTailLabelXY;
    private Positionable endHeadLabelXY;
    private Positionable labelXY;
    private UDrawable extremity2;
    private UDrawable extremity1;
    private double dx;
    private double dy;
    private boolean opale;
    private Cluster projectionCluster;
    private final Pragma pragma;
    private final HtmlColor backgroundColor;
    private final boolean useRankSame;

    public String toString() {
        return super.toString() + " color=" + this.lineColor;
    }

    private Cluster getCluster2(Bibliotekon bibliotekon, IEntity iEntity) {
        for (Cluster cluster : bibliotekon.allCluster()) {
            if (iEntity != cluster.getGroup()) continue;
            return cluster;
        }
        throw new IllegalArgumentException();
    }

    public Line(Link link, ColorSequence colorSequence, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, Bibliotekon bibliotekon, Pragma pragma) {
        AbstractTextBlock abstractTextBlock;
        TextBlock textBlock;
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this.useRankSame = iSkinParam.useRankSame();
        this.startUid = link.getEntityPort1(bibliotekon);
        this.endUid = link.getEntityPort2(bibliotekon);
        Cluster cluster = null;
        if (this.startUid.startsWith("za")) {
            cluster = this.getCluster2(bibliotekon, link.getEntity1());
        }
        Cluster cluster2 = null;
        if (this.endUid.startsWith("za")) {
            cluster2 = this.getCluster2(bibliotekon, link.getEntity2());
        }
        if (link.getColors() != null) {
            iSkinParam = link.getColors().mute(iSkinParam);
            fontConfiguration = fontConfiguration.mute(link.getColors());
        }
        this.backgroundColor = iSkinParam.getBackgroundColor();
        this.pragma = pragma;
        this.bibliotekon = bibliotekon;
        this.stringBounder = stringBounder;
        this.link = link;
        this.ltail = cluster;
        this.lhead = cluster2;
        this.lineColor = colorSequence.getValue();
        this.noteLabelColor = colorSequence.getValue();
        this.startTailColor = colorSequence.getValue();
        this.endHeadColor = colorSequence.getValue();
        if (Display.isNull(link.getLabel())) {
            if (this.getLinkArrow() == LinkArrow.NONE) {
                textBlock = null;
            } else {
                abstractTextBlock = new TextBlockArrow(Direction.RIGHT, fontConfiguration);
                TextBlockArrow textBlockArrow = new TextBlockArrow(Direction.LEFT, fontConfiguration);
                TextBlockArrow textBlockArrow2 = new TextBlockArrow(Direction.UP, fontConfiguration);
                TextBlockArrow textBlockArrow3 = new TextBlockArrow(Direction.DOWN, fontConfiguration);
                textBlock = new DirectionalTextBlock(abstractTextBlock, textBlockArrow, textBlockArrow2, textBlockArrow3);
            }
        } else {
            double d = this.startUid.equalsId(this.endUid) ? 6.0 : 1.0;
            TextBlock textBlock2 = TextBlockUtils.withMargin(link.getLabel().create(fontConfiguration, iSkinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), (ISkinSimple)iSkinParam, iSkinParam.maxMessageSize()), d, d);
            if (this.getLinkArrow() == LinkArrow.NONE) {
                textBlock = textBlock2;
            } else {
                TextBlock textBlock3 = new TextBlockArrow(Direction.RIGHT, fontConfiguration);
                textBlock3 = TextBlockUtils.mergeLR(textBlock2, textBlock3, VerticalAlignment.CENTER);
                TextBlock textBlock4 = new TextBlockArrow(Direction.LEFT, fontConfiguration);
                textBlock4 = TextBlockUtils.mergeLR(textBlock4, textBlock2, VerticalAlignment.CENTER);
                TextBlock textBlock5 = new TextBlockArrow(Direction.UP, fontConfiguration);
                textBlock5 = TextBlockUtils.mergeTB(textBlock5, textBlock2, HorizontalAlignment.CENTER);
                TextBlock textBlock6 = new TextBlockArrow(Direction.DOWN, fontConfiguration);
                textBlock6 = TextBlockUtils.mergeTB(textBlock2, textBlock6, HorizontalAlignment.CENTER);
                textBlock = new DirectionalTextBlock(textBlock3, textBlock4, textBlock5, textBlock6);
            }
        }
        if (link.getNote() == null) {
            abstractTextBlock = null;
        } else {
            abstractTextBlock = new EntityImageNoteLink(link.getNote(), link.getNoteColors(), iSkinParam);
            if (link.getNoteLinkStrategy() == NoteLinkStrategy.HALF_NOT_PRINTED || link.getNoteLinkStrategy() == NoteLinkStrategy.HALF_PRINTED_FULL) {
                this.divideLabelWidthByTwo = true;
            }
        }
        this.labelText = textBlock != null && abstractTextBlock != null ? (link.getNotePosition() == Position.LEFT ? TextBlockUtils.mergeLR(abstractTextBlock, textBlock, VerticalAlignment.CENTER) : (link.getNotePosition() == Position.RIGHT ? TextBlockUtils.mergeLR(textBlock, abstractTextBlock, VerticalAlignment.CENTER) : (link.getNotePosition() == Position.TOP ? TextBlockUtils.mergeTB(abstractTextBlock, textBlock, HorizontalAlignment.CENTER) : TextBlockUtils.mergeTB(textBlock, abstractTextBlock, HorizontalAlignment.CENTER)))) : (textBlock != null ? textBlock : (abstractTextBlock != null ? abstractTextBlock : null));
        this.startTailText = link.getQualifier1() == null ? null : Display.getWithNewlines(link.getQualifier1()).create(fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
        this.endHeadText = link.getQualifier2() == null ? null : Display.getWithNewlines(link.getQualifier2()).create(fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
    }

    public boolean hasNoteLabelText() {
        return this.labelText != null;
    }

    private LinkArrow getLinkArrow() {
        return this.link.getLinkArrow();
    }

    public void appendLine(GraphvizVersion graphvizVersion, StringBuilder stringBuilder, DotMode dotMode) {
        stringBuilder.append(this.startUid.getFullString());
        stringBuilder.append("->");
        stringBuilder.append(this.endUid.getFullString());
        stringBuilder.append("[");
        LinkType linkType = this.link.getTypePatchCluster();
        String string = linkType.getSpecificDecorationSvek();
        if (string.length() > 0 && !string.endsWith(",")) {
            string = string + ",";
        }
        stringBuilder.append(string);
        int n = this.link.getLength();
        if (this.useRankSame) {
            if (this.pragma.horizontalLineBetweenDifferentPackageAllowed() || this.link.isInvis() || n != 1) {
                stringBuilder.append("minlen=" + (n - 1));
                stringBuilder.append(",");
            }
        } else {
            stringBuilder.append("minlen=" + (n - 1));
            stringBuilder.append(",");
        }
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.lineColor) + "\"");
        if (this.labelText != null) {
            stringBuilder.append(",");
            if (graphvizVersion.modeSafe() || dotMode == DotMode.NO_LEFT_RIGHT_AND_XLABEL) {
                stringBuilder.append("xlabel=<");
            } else {
                stringBuilder.append("label=<");
            }
            Line.appendTable(stringBuilder, this.eventuallyDivideByTwo(this.labelText.calculateDimension(this.stringBounder)), this.noteLabelColor, graphvizVersion);
            stringBuilder.append(">");
        }
        if (this.startTailText != null) {
            stringBuilder.append(",");
            stringBuilder.append("taillabel=<");
            Line.appendTable(stringBuilder, this.startTailText.calculateDimension(this.stringBounder), this.startTailColor, graphvizVersion);
            stringBuilder.append(">");
        }
        if (this.endHeadText != null) {
            stringBuilder.append(",");
            stringBuilder.append("headlabel=<");
            Line.appendTable(stringBuilder, this.endHeadText.calculateDimension(this.stringBounder), this.endHeadColor, graphvizVersion);
            stringBuilder.append(">");
        }
        if (this.link.isInvis()) {
            stringBuilder.append(",");
            stringBuilder.append("style=invis");
        }
        if (!this.link.isConstraint() || this.link.hasTwoEntryPointsSameContainer()) {
            stringBuilder.append(",constraint=false");
        }
        if (this.link.getSametail() != null) {
            stringBuilder.append(",sametail=" + this.link.getSametail());
        }
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private Dimension2D eventuallyDivideByTwo(Dimension2D dimension2D) {
        if (this.divideLabelWidthByTwo) {
            return new Dimension2DDouble(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
        }
        return dimension2D;
    }

    public String rankSame() {
        if (!this.pragma.horizontalLineBetweenDifferentPackageAllowed() && this.link.getLength() == 1) {
            return "{rank=same; " + this.getStartUidPrefix() + "; " + this.getEndUidPrefix() + "}";
        }
        return null;
    }

    public static void appendTable(StringBuilder stringBuilder, Dimension2D dimension2D, int n, GraphvizVersion graphvizVersion) {
        int n2 = (int)dimension2D.getWidth();
        int n3 = (int)dimension2D.getHeight();
        Line.appendTable(stringBuilder, n2, n3, n);
    }

    public static void appendTable(StringBuilder stringBuilder, int n, int n2, int n3) {
        stringBuilder.append("<TABLE ");
        stringBuilder.append("BGCOLOR=\"" + StringUtils.getAsHtml(n3) + "\" ");
        stringBuilder.append("FIXEDSIZE=\"TRUE\" WIDTH=\"" + n + "\" HEIGHT=\"" + n2 + "\">");
        stringBuilder.append("<TR");
        stringBuilder.append(">");
        stringBuilder.append("<TD");
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    public final String getStartUidPrefix() {
        return this.startUid.getPrefix();
    }

    public final String getEndUidPrefix() {
        return this.endUid.getPrefix();
    }

    private UDrawable getExtremity(LinkDecor linkDecor, SvekUtils.PointListIterator pointListIterator, final Point2D point2D, double d, Cluster cluster, Shape shape) {
        ExtremityFactory extremityFactory = linkDecor.getExtremityFactory(this.backgroundColor);
        if (cluster != null) {
            if (extremityFactory != null) {
                return extremityFactory.createUDrawable(point2D, d, null);
            }
            if (linkDecor == LinkDecor.EXTENDS) {
                return new ExtremityFactoryExtends(this.backgroundColor).createUDrawable(point2D, d, null);
            }
            return null;
        }
        if (extremityFactory != null) {
            Object object = pointListIterator.next();
            if (object.size() == 0) {
                return extremityFactory.createUDrawable(point2D, d, null);
            }
            Point2D point2D2 = (Point2D)object.get(0);
            Point2D point2D3 = (Point2D)object.get(1);
            Point2D point2D4 = (Point2D)object.get(2);
            Side side = null;
            if (shape != null) {
                side = shape.getClusterPosition().getClosestSide(point2D3);
            }
            return extremityFactory.createUDrawable(point2D2, point2D3, point2D4, side);
        }
        if (linkDecor == LinkDecor.NONE) {
            UPolygon uPolygon = new UPolygon((List<Point2D.Double>)pointListIterator.cloneMe().next());
            final Point2D point2D5 = uPolygon.checkMiddleContactForSpecificTriangle(point2D);
            if (point2D5 != null) {
                return new UDrawable(){

                    public void drawU(UGraphic uGraphic) {
                        ULine uLine = new ULine(point2D5.getX() - point2D.getX(), point2D5.getY() - point2D.getY());
                        uGraphic = uGraphic.apply(new UTranslate(point2D));
                        uGraphic.draw(uLine);
                    }
                };
            }
        } else if (linkDecor != LinkDecor.NONE) {
            final UPolygon uPolygon = new UPolygon((List<Point2D.Double>)pointListIterator.next());
            return new UDrawable(){

                public void drawU(UGraphic uGraphic) {
                    uGraphic.draw(uPolygon);
                }
            };
        }
        return null;
    }

    public void solveLine(String string, int n, MinFinder minFinder) {
        Point2D point2D;
        if (this.link.isInvis()) {
            return;
        }
        int n2 = SvekUtils.getIndexFromColor(string, this.lineColor);
        if (n2 == -1) {
            return;
        }
        if ((n2 = string.indexOf("d=\"", n2)) == -1) {
            throw new IllegalStateException();
        }
        int n3 = string.indexOf("\"", n2 + 3);
        String string2 = string.substring(n2 + 3, n3);
        if (!DotPath.isPathConsistent(string2)) {
            return;
        }
        this.dotPath = new DotPath(string2, n);
        if (this.projectionCluster != null) {
            this.projectionCluster.manageEntryExitPoint(this.stringBounder);
        }
        this.dotPath = this.dotPath.simulateCompound(this.lhead, this.ltail);
        SvekUtils.PointListIterator pointListIterator = SvekUtils.PointListIterator.create(string.substring(n3), n, this.lineColor);
        LinkType linkType = this.link.getType();
        this.extremity1 = this.getExtremity(linkType.getDecor2(), pointListIterator, this.dotPath.getStartPoint(), this.dotPath.getStartAngle() + Math.PI, this.ltail, this.bibliotekon.getShape(this.link.getEntity1()));
        this.extremity2 = this.getExtremity(linkType.getDecor1(), pointListIterator, this.dotPath.getEndPoint(), this.dotPath.getEndAngle(), this.lhead, this.bibliotekon.getShape(this.link.getEntity2()));
        if (this.extremity1 instanceof Extremity && this.extremity2 instanceof Extremity) {
            point2D = ((Extremity)this.extremity1).somePoint();
            Point2D point2D2 = ((Extremity)this.extremity2).somePoint();
            if (point2D != null && point2D2 != null) {
                double d = point2D.distance(this.dotPath.getStartPoint());
                double d2 = point2D.distance(this.dotPath.getEndPoint());
                double d3 = point2D2.distance(this.dotPath.getStartPoint());
                double d4 = point2D2.distance(this.dotPath.getEndPoint());
                if (d > d2 && d4 > d3) {
                    pointListIterator = SvekUtils.PointListIterator.create(string.substring(n3), n, this.lineColor);
                    this.extremity2 = this.getExtremity(linkType.getDecor1(), pointListIterator, this.dotPath.getEndPoint(), this.dotPath.getEndAngle(), this.lhead, this.bibliotekon.getShape(this.link.getEntity2()));
                    this.extremity1 = this.getExtremity(linkType.getDecor2(), pointListIterator, this.dotPath.getStartPoint(), this.dotPath.getStartAngle() + Math.PI, this.ltail, this.bibliotekon.getShape(this.link.getEntity1()));
                }
            }
        }
        if (this.labelText != null && (point2D = this.getXY(string, this.noteLabelColor, n)) != null) {
            minFinder.manage(point2D);
            this.labelXY = TextBlockUtils.asPositionable(this.labelText, this.stringBounder, point2D);
        }
        if (this.startTailText != null && (point2D = this.getXY(string, this.startTailColor, n)) != null) {
            minFinder.manage(point2D);
            this.startTailLabelXY = TextBlockUtils.asPositionable(this.startTailText, this.stringBounder, point2D);
        }
        if (this.endHeadText != null && (point2D = this.getXY(string, this.endHeadColor, n)) != null) {
            minFinder.manage(point2D);
            this.endHeadLabelXY = TextBlockUtils.asPositionable(this.endHeadText, this.stringBounder, point2D);
            minFinder.manage(point2D.getX() - 15.0, point2D.getY());
        }
        if (!this.isOpalisable()) {
            this.setOpale(false);
        }
    }

    private boolean isOpalisable() {
        return this.dotPath.getBeziers().size() <= 1;
    }

    private Point2D.Double getXY(String string, int n, int n2) {
        int n3 = SvekUtils.getIndexFromColor(string, n);
        if (n3 == -1) {
            return null;
        }
        return SvekUtils.getMinXY(SvekUtils.extractPointsList(string, n3, n2));
    }

    public void drawU(UGraphic uGraphic, HtmlColor object) {
        double d;
        Object object2;
        Object object3;
        if (this.opale) {
            return;
        }
        uGraphic.draw(new UComment("link " + this.link.getEntity1().getCode().getFullName() + " to " + this.link.getEntity2().getCode().getFullName()));
        double d2 = 0.0;
        double d3 = 0.0;
        Url url = this.link.getUrl();
        if (url != null) {
            uGraphic.startUrl(url);
        }
        if (this.link.isAutoLinkOfAGroup() && (object3 = this.bibliotekon.getCluster((IGroup)this.link.getEntity1())) != null) {
            d2 += ((Cluster)object3).getWidth();
            d2 -= this.dotPath.getStartPoint().getX() - ((Cluster)object3).getMinX();
        }
        d2 += this.dx;
        d3 += this.dy;
        if (this.link.isInvis()) {
            return;
        }
        if (this.link.getColors() != null) {
            object3 = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (object3 != null) {
                object = object3;
            }
        } else if (this.link.getSpecificColor() != null) {
            object = this.link.getSpecificColor();
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(null)).apply(new UChangeColor((HtmlColor)object));
        object3 = this.link.getType();
        UStroke uStroke = ((LinkType)object3).getStroke();
        if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
            uStroke = this.link.getColors().getSpecificLineStroke();
        }
        uGraphic = uGraphic.apply(uStroke);
        double d4 = 0.0;
        if (this.dotPath == null) {
            Log.info("DotPath is null for " + this);
            return;
        }
        DotPath dotPath = this.dotPath;
        if (this.link.getEntity2().isGroup() && this.link.getEntity2().getUSymbol() instanceof USymbolFolder && (object2 = this.bibliotekon.getCluster((IGroup)this.link.getEntity2())) != null) {
            d = ((Cluster)object2).checkFolderPosition(this.dotPath.getEndPoint(), uGraphic.getStringBounder());
            dotPath = new DotPath(this.dotPath);
            dotPath.moveEndPoint(0.0, d);
            d4 = d;
        }
        dotPath.setComment(this.link.getEntity1().getCode().getFullName() + "-" + this.link.getEntity2().getCode().getFullName());
        uGraphic.apply(new UTranslate(d2, d3)).draw(dotPath);
        uGraphic = uGraphic.apply(new UStroke()).apply(new UChangeColor((HtmlColor)object));
        if (this.extremity2 != null) {
            object2 = uGraphic;
            object2 = ((LinkType)object3).getDecor1().isFill() ? object2.apply(new UChangeBackColor((HtmlColor)object)) : object2.apply(new UChangeBackColor(null));
            this.extremity2.drawU(object2.apply(new UTranslate(d2, d3)));
        }
        if (this.extremity1 != null) {
            object2 = uGraphic;
            object2 = ((LinkType)object3).getDecor2().isFill() ? object2.apply(new UChangeBackColor((HtmlColor)object)) : object2.apply(new UChangeBackColor(null));
            this.extremity1.drawU(object2.apply(new UTranslate(d2, d3)));
        }
        if (this.labelText != null && this.labelXY != null && this.link.getNoteLinkStrategy() != NoteLinkStrategy.HALF_NOT_PRINTED) {
            this.labelText.drawU(uGraphic.apply(new UTranslate(d2 + this.labelXY.getPosition().getX(), d3 + this.labelXY.getPosition().getY())));
        }
        if (this.startTailText != null && this.startTailLabelXY != null && this.startTailLabelXY.getPosition() != null) {
            this.startTailText.drawU(uGraphic.apply(new UTranslate(d2 + this.startTailLabelXY.getPosition().getX(), d3 + this.startTailLabelXY.getPosition().getY())));
        }
        if (this.endHeadText != null && this.endHeadLabelXY != null && this.endHeadLabelXY.getPosition() != null) {
            this.endHeadText.drawU(uGraphic.apply(new UTranslate(d2 + this.endHeadLabelXY.getPosition().getX(), d3 + this.endHeadLabelXY.getPosition().getY())));
        }
        if (((LinkType)object3).getMiddleDecor() != LinkMiddleDecor.NONE) {
            object2 = this.dotPath.getMiddle();
            d = ((PointAndAngle)object2).getAngle();
            double d5 = -d * 180.0 / Math.PI;
            UDrawable uDrawable = ((LinkType)object3).getMiddleDecor().getMiddleFactory().createUDrawable(d5 - 45.0);
            uDrawable.drawU(uGraphic.apply(new UTranslate(d2 + ((PointAndAngle)object2).getX(), d3 + ((PointAndAngle)object2).getY())));
        }
        if (url != null) {
            uGraphic.closeAction();
        }
    }

    public boolean isInverted() {
        return this.link.isInverted();
    }

    private double getDecorDzeta() {
        LinkType linkType = this.link.getType();
        int n = linkType.getDecor1().getMargin();
        int n2 = linkType.getDecor2().getMargin();
        return n + n2;
    }

    public double getHorizontalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (!this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum arithmeticStrategySum = new ArithmeticStrategySum();
        if (this.labelText != null) {
            arithmeticStrategySum.eat(this.labelText.calculateDimension(stringBounder).getWidth());
        }
        if (this.startTailText != null) {
            arithmeticStrategySum.eat(this.startTailText.calculateDimension(stringBounder).getWidth());
        }
        if (this.endHeadText != null) {
            arithmeticStrategySum.eat(this.endHeadText.calculateDimension(stringBounder).getWidth());
        }
        return arithmeticStrategySum.getResult() + this.getDecorDzeta();
    }

    private boolean isHorizontal() {
        return this.link.getLength() == 1;
    }

    public double getVerticalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum arithmeticStrategySum = new ArithmeticStrategySum();
        if (this.labelText != null) {
            arithmeticStrategySum.eat(this.labelText.calculateDimension(stringBounder).getHeight());
        }
        if (this.startTailText != null) {
            arithmeticStrategySum.eat(this.startTailText.calculateDimension(stringBounder).getHeight());
        }
        if (this.endHeadText != null) {
            arithmeticStrategySum.eat(this.endHeadText.calculateDimension(stringBounder).getHeight());
        }
        return arithmeticStrategySum.getResult() + this.getDecorDzeta();
    }

    public void manageCollision(Collection<Shape> collection) {
        for (Shape shape : collection) {
            Positionable positionable = PositionableUtils.addMargin(shape, 8.0, 8.0);
            if (this.startTailText != null && this.startTailLabelXY != null && PositionableUtils.intersect(positionable, this.startTailLabelXY)) {
                this.startTailLabelXY = PositionableUtils.moveAwayFrom(positionable, this.startTailLabelXY);
            }
            if (this.endHeadText == null || this.endHeadLabelXY == null || !PositionableUtils.intersect(positionable, this.endHeadLabelXY)) continue;
            this.endHeadLabelXY = PositionableUtils.moveAwayFrom(positionable, this.endHeadLabelXY);
        }
    }

    private void avoid(Point2D.Double double_, Positionable positionable, Shape shape) {
        Oscillator oscillator = new Oscillator();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        while (this.cut(positionable, shape)) {
            Point2D.Double double_3 = oscillator.nextPosition();
            double_.setLocation(double_2.x + double_3.x, double_2.y + double_3.y);
        }
    }

    private boolean cut(Positionable positionable, Shape shape) {
        return BezierUtils.intersect(positionable, shape) || this.tooClose(positionable);
    }

    private boolean tooClose(Positionable positionable) {
        Dimension2D dimension2D;
        double d = this.dotPath.getMinDist(BezierUtils.getCenter(positionable));
        return d < (dimension2D = positionable.getSize()).getWidth() / 2.0 + 2.0 || d < dimension2D.getHeight() / 2.0 + 2.0;
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.dx += d;
        this.dy += d2;
    }

    public final DotPath getDotPath() {
        DotPath dotPath = new DotPath(this.dotPath);
        dotPath.moveSvek(this.dx, this.dy);
        return dotPath;
    }

    public int getLength() {
        return this.link.getLength();
    }

    public void setOpale(boolean bl) {
        this.link.setOpale(bl);
        this.opale = bl;
    }

    public boolean isOpale() {
        return this.opale;
    }

    public boolean isHorizontalSolitary() {
        return this.link.isHorizontalSolitary();
    }

    public boolean isLinkFromOrTo(IEntity iEntity) {
        return this.link.getEntity1() == iEntity || this.link.getEntity2() == iEntity;
    }

    public boolean hasEntryPoint() {
        return this.link.hasEntryPoint();
    }

    public void setProjectionCluster(Cluster cluster) {
        this.projectionCluster = cluster;
    }

    @Override
    public boolean isHidden() {
        return this.link.isHidden();
    }

    public boolean sameConnections(Line line) {
        return this.link.sameConnections(line.link);
    }

    private boolean isAutolink() {
        return this.link.getEntity1() == this.link.getEntity2();
    }

    public Point2D getMyPoint(IEntity iEntity) {
        if (this.link.getEntity1() == iEntity) {
            return this.moveDelta(this.dotPath.getStartPoint());
        }
        if (this.link.getEntity2() == iEntity) {
            return this.moveDelta(this.dotPath.getEndPoint());
        }
        throw new IllegalArgumentException();
    }

    private Point2D moveDelta(Point2D point2D) {
        return new Point2D.Double(point2D.getX() + this.dx, point2D.getY() + this.dy);
    }

    public boolean isLink(Link link) {
        return this.link == link;
    }

    public Point2D getStartContactPoint() {
        Point2D point2D = this.dotPath.getStartPoint();
        if (point2D == null) {
            return null;
        }
        return new Point2D.Double(this.dx + point2D.getX(), this.dy + point2D.getY());
    }

    public Point2D getEndContactPoint() {
        Point2D point2D = this.dotPath.getEndPoint();
        if (point2D == null) {
            return null;
        }
        return new Point2D.Double(this.dx + point2D.getX(), this.dy + point2D.getY());
    }

    public IEntity getOther(IEntity iEntity) {
        if (this.link.contains(iEntity)) {
            return this.link.getOther(iEntity);
        }
        return null;
    }

    class DirectionalTextBlock
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock right;
        private final TextBlock left;
        private final TextBlock up;
        private final TextBlock down;

        DirectionalTextBlock(TextBlock textBlock, TextBlock textBlock2, TextBlock textBlock3, TextBlock textBlock4) {
            this.right = textBlock;
            this.left = textBlock2;
            this.up = textBlock3;
            this.down = textBlock4;
        }

        public void drawU(UGraphic uGraphic) {
            Direction direction = this.getDirection();
            if (Line.this.getLinkArrow() == LinkArrow.BACKWARD) {
                direction = direction.getInv();
            }
            switch (direction) {
                case RIGHT: {
                    this.right.drawU(uGraphic);
                    break;
                }
                case LEFT: {
                    this.left.drawU(uGraphic);
                    break;
                }
                case UP: {
                    this.up.drawU(uGraphic);
                    break;
                }
                case DOWN: {
                    this.down.drawU(uGraphic);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public Dimension2D calculateDimension(StringBounder stringBounder) {
            return this.right.calculateDimension(stringBounder);
        }

        private Direction getDirection() {
            if (Line.this.isAutolink()) {
                double d = Line.this.dotPath.getStartAngle();
                return Direction.LEFT;
            }
            Point2D point2D = Line.this.dotPath.getStartPoint();
            Point2D point2D2 = Line.this.dotPath.getEndPoint();
            double d = Math.atan2(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            if (d > -0.7853981633974483 && d < 0.7853981633974483) {
                return Direction.DOWN;
            }
            if (d > 2.356194490192345 || d < -2.356194490192345) {
                return Direction.UP;
            }
            return point2D2.getX() > point2D.getX() ? Direction.RIGHT : Direction.LEFT;
        }
    }
}

