/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SingleStrategy {
    SQUARRE,
    HLINE,
    VLINE;


    public Collection<Link> generateLinks(List<ILeaf> list) {
        return this.putInSquare(list);
    }

    private Collection<Link> putInSquare(List<ILeaf> list) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
        int n = SingleStrategy.computeBranch(list.size());
        int n2 = 0;
        for (int i = 1; i < list.size(); ++i) {
            Link link;
            IEntity iEntity;
            int n3 = i - n2;
            IEntity iEntity2 = list.get(i);
            if (n3 == n) {
                iEntity = list.get(n2);
                link = new Link(iEntity, iEntity2, linkType, Display.NULL, 2);
                n2 = i;
            } else {
                iEntity = list.get(i - 1);
                link = new Link(iEntity, iEntity2, linkType, Display.NULL, 1);
            }
            arrayList.add(link);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    static int computeBranch(int n) {
        double d = Math.sqrt(n);
        int n2 = (int)d;
        if (n2 * n2 == n) {
            return n2;
        }
        return n2 + 1;
    }
}

