/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityStateLine1
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final Point2D dest;
    private final double radius = 7.0;
    private final double angle;

    public Point2D somePoint() {
        return this.dest;
    }

    public ExtremityStateLine1(double d, Point2D point2D) {
        this.angle = this.manageround(d);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new Point2D.Double(point2D.getX(), point2D.getY());
        this.polygon.addPoint(-9.0, -4.0);
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(point2D.getX(), point2D.getY());
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic.apply(new UChangeBackColor(uGraphic.getParam().getColor())).apply(new UTranslate(-7.0 * Math.cos(this.angle), -7.0 * Math.sin(this.angle))).draw(this.polygon);
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
        uGraphic.apply(new UStroke(1.5)).apply(new UTranslate(this.dest.getX() - 7.0, this.dest.getY() - 7.0)).draw(new UEllipse(14.0, 14.0));
        ExtremityStateLine1.drawLine(uGraphic, this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 0.7853981633974483), this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 3.9269908169872414));
        ExtremityStateLine1.drawLine(uGraphic, this.getPointOnCircle(this.dest.getX(), this.dest.getY(), -0.7853981633974483), this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 2.356194490192345));
    }

    private Point2D getPointOnCircle(double d, double d2, double d3) {
        double d4 = d + 7.0 * Math.cos(d3);
        double d5 = d2 + 7.0 * Math.sin(d3);
        return new Point2D.Double(d4, d5);
    }

    private static void drawLine(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        uGraphic.apply(new UTranslate(point2D.getX(), point2D.getY())).draw(new ULine(d, d2));
    }
}

