/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.ConnectedCircle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterfaceEye1
extends AbstractEntityImage {
    private static final int SIZE = 24;
    private final TextBlock desc;
    private final Bibliotekon bibliotekon;
    private final Url url;

    public EntityImageLollipopInterfaceEye1(ILeaf iLeaf, ISkinParam iSkinParam, Bibliotekon bibliotekon) {
        super(iLeaf, iSkinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = iLeaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrl99();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    public final void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo())));
        uGraphic = uGraphic.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo())));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        UEllipse uEllipse = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing()) {
            // empty if block
        }
        uGraphic.apply(new UStroke(1.5)).apply(new UTranslate(5.0, 5.0)).draw(uEllipse);
        uGraphic = uGraphic.apply(new UChangeBackColor(null));
        Point2D point2D = this.bibliotekon.getShape(this.getEntity()).getPosition();
        List<Line> list = this.bibliotekon.getAllLineConnectedTo(this.getEntity());
        UTranslate uTranslate = new UTranslate(point2D).reverse();
        ConnectedCircle connectedCircle = new ConnectedCircle(12.0);
        for (Line line : list) {
            Point2D point2D2 = line.getMyPoint(this.getEntity());
            point2D2 = uTranslate.getTranslated(point2D2);
            connectedCircle.addSecondaryConnection(point2D2);
        }
        connectedCircle.drawU(uGraphic);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

