/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class Opale
extends AbstractTextBlock
implements TextBlock {
    private final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private Direction strategy;
    private Point2D pp1;
    private Point2D pp2;
    private final boolean withLink;
    private final TextBlock textBlock;
    private final double delta = 4.0;

    public Opale(HtmlColor htmlColor, HtmlColor htmlColor2, TextBlock textBlock, boolean bl, boolean bl2) {
        this.noteBackgroundColor = htmlColor2;
        this.withLink = bl2;
        this.withShadow = bl;
        this.borderColor = htmlColor;
        this.textBlock = textBlock;
    }

    public void setOpale(Direction direction, Point2D point2D, Point2D point2D2) {
        this.strategy = direction;
        this.pp1 = point2D;
        this.pp2 = point2D2;
    }

    private final double getWidth(StringBounder stringBounder) {
        return this.textBlock.calculateDimension(stringBounder).getWidth() + 6.0 + 15.0;
    }

    private final double getHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getHeight() + 10.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getHeight(stringBounder);
        double d2 = this.getWidth(stringBounder);
        return new Dimension2DDouble(d2, d);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UPolygon uPolygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            uPolygon.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        uGraphic.draw(uPolygon);
        if (this.withLink) {
            UPolygon uPolygon2;
            if (this.strategy == Direction.LEFT) {
                uPolygon2 = this.getPolygonLeft(stringBounder, this.pp1, this.pp2);
            } else if (this.strategy == Direction.RIGHT) {
                uPolygon2 = this.getPolygonRight(stringBounder, this.pp1, this.pp2);
            } else if (this.strategy == Direction.UP) {
                uPolygon2 = this.getPolygonUp(stringBounder, this.pp1, this.pp2);
            } else if (this.strategy == Direction.DOWN) {
                uPolygon2 = this.getPolygonDown(stringBounder, this.pp1, this.pp2);
            } else {
                throw new IllegalArgumentException();
            }
            uGraphic.draw(uPolygon2);
        }
        uGraphic.apply(new UTranslate(this.getWidth(stringBounder) - 10.0, 0.0)).draw(new ULine(0.0, 10.0));
        uGraphic.apply(new UTranslate(this.getWidth(stringBounder), 10.0)).draw(new ULine(-10.0, 0.0));
        this.textBlock.drawU(uGraphic.apply(new UTranslate(6.0, 5.0)));
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonLeft(StringBounder stringBounder, Point2D point2D, Point2D point2D2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        double d = point2D.getY() - 4.0;
        d = MathUtils.limitation(d, 0.0, this.getHeight(stringBounder) - 8.0);
        uPolygon.addPoint(0.0, d);
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(0.0, d + 8.0);
        uPolygon.addPoint(0.0, this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonRight(StringBounder stringBounder, Point2D point2D, Point2D point2D2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        double d = point2D.getY() - 4.0;
        d = MathUtils.limitation(d, 10.0, this.getHeight(stringBounder) - 8.0);
        uPolygon.addPoint(this.getWidth(stringBounder), d + 8.0);
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(this.getWidth(stringBounder), d);
        uPolygon.addPoint(this.getWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonUp(StringBounder stringBounder, Point2D point2D, Point2D point2D2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        double d = point2D.getX() - 4.0;
        d = MathUtils.limitation(d, 0.0, this.getWidth(stringBounder) - 10.0);
        uPolygon.addPoint(d + 8.0, 0.0);
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(d, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private UPolygon getPolygonDown(StringBounder stringBounder, Point2D point2D, Point2D point2D2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getHeight(stringBounder));
        double d = point2D.getX() - 4.0;
        d = MathUtils.limitation(d, 0.0, this.getWidth(stringBounder));
        uPolygon.addPoint(d, this.getHeight(stringBounder));
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(d + 8.0, this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        uPolygon.addPoint(this.getWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    public final int getMarginX1() {
        return 6;
    }
}

