/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.CommandChangeStateByPlayerCode;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimeTickBuilder;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandChangeStateByTime
extends SingleLineCommand2<TimingDiagram> {
    public CommandChangeStateByTime() {
        super(CommandChangeStateByTime.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("[%s]*"), TimeTickBuilder.expressionAtWithoutArobase("TIME"), new RegexLeaf("[%s]*is[%s]*"), CommandChangeStateByPlayerCode.getStateOrHidden(), new RegexLeaf("[%s]*"), CommandChangeStateByTime.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("COMMENT", "(?:[%s]*:[%s]*(.*?))?"), new RegexLeaf("[%s]*$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram timingDiagram, RegexResult regexResult) {
        Player player = timingDiagram.getLastPlayer();
        if (player == null) {
            return CommandExecutionResult.error("Missing @ line before this");
        }
        TimeTick timeTick = TimeTickBuilder.parseTimeTick("TIME", regexResult, timingDiagram);
        String string = regexResult.get("COMMENT", 0);
        Colors colors = CommandChangeStateByTime.color().getColor(regexResult, timingDiagram.getSkinParam().getIHtmlColorSet());
        player.setState(timeTick, regexResult.getLazzy("STATE", 0), string, colors);
        timingDiagram.addTime(timeTick);
        return CommandExecutionResult.ok();
    }
}

