/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeArrow
implements UDrawable {
    private final Point2D start;
    private final Point2D end;
    private final Display label;
    private final ISkinSimple spriteContainer;

    public static TimeArrow create(IntricatedPoint intricatedPoint, IntricatedPoint intricatedPoint2, Display display, ISkinSimple iSkinSimple) {
        TimeArrow timeArrow = new TimeArrow(intricatedPoint.getPointA(), intricatedPoint2.getPointA(), display, iSkinSimple);
        TimeArrow timeArrow2 = new TimeArrow(intricatedPoint.getPointA(), intricatedPoint2.getPointB(), display, iSkinSimple);
        TimeArrow timeArrow3 = new TimeArrow(intricatedPoint.getPointB(), intricatedPoint2.getPointA(), display, iSkinSimple);
        TimeArrow timeArrow4 = new TimeArrow(intricatedPoint.getPointB(), intricatedPoint2.getPointB(), display, iSkinSimple);
        return TimeArrow.shorter(timeArrow, timeArrow2, timeArrow3, timeArrow4);
    }

    private TimeArrow(Point2D point2D, Point2D point2D2, Display display, ISkinSimple iSkinSimple) {
        this.start = point2D;
        this.end = point2D2;
        this.label = display;
        this.spriteContainer = iSkinSimple;
    }

    private double getAngle() {
        return Math.atan2(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
    }

    private static TimeArrow shorter(TimeArrow timeArrow, TimeArrow timeArrow2) {
        if (timeArrow.len() < timeArrow2.len()) {
            return timeArrow;
        }
        return timeArrow2;
    }

    private static TimeArrow shorter(TimeArrow timeArrow, TimeArrow timeArrow2, TimeArrow timeArrow3, TimeArrow timeArrow4) {
        return TimeArrow.shorter(TimeArrow.shorter(timeArrow, timeArrow2), TimeArrow.shorter(timeArrow3, timeArrow4));
    }

    private double len() {
        return this.start.distance(this.end);
    }

    public TimeArrow translate(UTranslate uTranslate) {
        return new TimeArrow(uTranslate.getTranslated(this.start), uTranslate.getTranslated(this.end), this.label, this.spriteContainer);
    }

    public static Point2D onCircle(Point2D point2D, double d) {
        double d2 = point2D.getX() - Math.sin(d) * 8.0;
        double d3 = point2D.getY() - Math.cos(d) * 8.0;
        return new Point2D.Double(d2, d3);
    }

    private FontConfiguration getFontConfiguration() {
        UFont uFont = UFont.serif(14);
        return new FontConfiguration(uFont, HtmlColorUtils.BLUE, HtmlColorUtils.BLUE, false);
    }

    public void drawU(UGraphic uGraphic) {
        double d = this.getAngle();
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UStroke());
        ULine uLine = new ULine(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
        uGraphic.apply(new UTranslate(this.start)).draw(uLine);
        Point2D point2D = TimeArrow.onCircle(this.end, d + 0.3490658503988659);
        Point2D point2D2 = TimeArrow.onCircle(this.end, d - 0.3490658503988659);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(point2D.getX(), point2D.getY());
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(this.end.getX(), this.end.getY());
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.BLUE));
        uGraphic.draw(uPolygon);
        TextBlock textBlock = this.label.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.spriteContainer);
        double d2 = (point2D.getX() + point2D2.getX()) / 2.0;
        double d3 = (point2D.getY() + point2D2.getY()) / 2.0;
        if (this.start.getY() < this.end.getY()) {
            Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
            d3 -= dimension2D.getHeight();
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(d2, d3)));
    }
}

