/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Clock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;

public class TimeTickBuilder {
    private static final String WITHOUT_AROBASE = "(\\+?)(\\d+\\.?\\d*)";
    private static final String WITH_AROBASE = "@(\\+?)(\\d+\\.?\\d*)";

    public static RegexLeaf expressionAtWithoutArobase(String string) {
        return new RegexLeaf(string, WITHOUT_AROBASE);
    }

    public static RegexLeaf expressionAtWithArobase(String string) {
        return new RegexLeaf(string, WITH_AROBASE);
    }

    public static RegexLeaf optionalExpressionAtWithArobase(String string) {
        return new RegexLeaf(string, "(?:@(\\+?)(\\d+\\.?\\d*))?");
    }

    public static TimeTick parseTimeTick(String string, RegexResult regexResult, Clock clock) {
        String string2 = regexResult.get(string, 1);
        if (string2 == null) {
            return clock.getNow();
        }
        boolean bl = "+".equals(regexResult.get(string, 0));
        BigDecimal bigDecimal = new BigDecimal(string2);
        if (bl) {
            bigDecimal = clock.getNow().getTime().add(bigDecimal);
        }
        return new TimeTick(bigDecimal);
    }
}

