/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.braille.UGraphicBraille;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private final ColorMapper colorMapper;
    private final double dpiFactor;
    private final HtmlColor mybackcolor;
    private final String metadata;
    private final String warningOrError;
    private final double margin1;
    private final double margin2;
    private final Animation animation;
    private final boolean useHandwritten;
    private UDrawable udrawable;
    private final double externalMargin1;
    private final double externalMargin2;
    private UStroke borderStroke;
    private HtmlColor borderColor;
    private double borderCorner;
    private static Semaphore SEMAPHORE_SMALL;
    private static Semaphore SEMAPHORE_BIG;
    private static int MAX_PRICE;

    public ImageBuilder(ColorMapper colorMapper, double d, HtmlColor htmlColor, String string, String string2, double d2, double d3, Animation animation, boolean bl) {
        this.colorMapper = colorMapper;
        this.dpiFactor = d;
        this.mybackcolor = htmlColor;
        this.metadata = string;
        this.warningOrError = string2;
        this.margin1 = d2;
        this.margin2 = d3;
        this.animation = animation;
        this.useHandwritten = bl;
        this.externalMargin1 = 0.0;
        this.externalMargin2 = 0.0;
        this.borderStroke = null;
        this.borderColor = null;
        this.borderCorner = 0.0;
    }

    public ImageBuilder(ISkinParam iSkinParam, double d, String string, String string2, double d2, double d3, Animation animation) {
        this(iSkinParam, d, string, string2, d2, d3, animation, iSkinParam.getBackgroundColor());
    }

    public ImageBuilder(ISkinParam iSkinParam, double d, String string, String string2, double d2, double d3, Animation animation, HtmlColor htmlColor) {
        Rose rose = new Rose();
        this.borderColor = rose.getHtmlColor(iSkinParam, ColorParam.diagramBorder);
        this.borderStroke = iSkinParam.getThickness(LineParam.diagramBorder, null);
        this.borderCorner = iSkinParam.getRoundCorner("diagramBorder", null);
        if (this.borderStroke == null && this.borderColor != null) {
            this.borderStroke = new UStroke();
        }
        this.colorMapper = iSkinParam.getColorMapper();
        this.dpiFactor = d;
        this.mybackcolor = htmlColor;
        this.metadata = string;
        this.warningOrError = string2;
        this.margin1 = d2;
        this.margin2 = d3;
        this.animation = animation;
        this.useHandwritten = iSkinParam.handwritten();
        this.externalMargin1 = 0.0;
        this.externalMargin2 = 0.0;
    }

    public void setUDrawable(UDrawable uDrawable) {
        this.udrawable = uDrawable;
    }

    public ImageData writeImageTOBEMOVED(FileFormatOption fileFormatOption, long l, OutputStream outputStream) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.MJPEG) {
            return this.writeImageMjpeg(outputStream, fileFormat.getDefaultStringBounder());
        }
        if (fileFormat == FileFormat.ANIMATED_GIF) {
            return this.writeImageAnimatedGif(outputStream, fileFormat.getDefaultStringBounder());
        }
        return this.writeImageInternal(fileFormatOption, l, outputStream, this.animation);
    }

    public static void setMaxPixel(int n) {
        MAX_PRICE = n / 2;
        SEMAPHORE_SMALL = new Semaphore(MAX_PRICE, true);
        SEMAPHORE_BIG = new Semaphore(MAX_PRICE, true);
    }

    private int getPrice(FileFormatOption fileFormatOption, Dimension2D dimension2D) {
        if (MAX_PRICE == 0) {
            return 0;
        }
        int n = Math.min(MAX_PRICE, (int)(dimension2D.getHeight() * this.dpiFactor) * (int)(dimension2D.getWidth() * this.dpiFactor));
        return n;
    }

    private Semaphore getSemaphore(int n) {
        if (n == 0) {
            return null;
        }
        if (n == MAX_PRICE) {
            return SEMAPHORE_BIG;
        }
        return SEMAPHORE_SMALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData writeImageInternal(FileFormatOption fileFormatOption, long l, OutputStream outputStream, Animation animation) throws IOException {
        int n;
        Semaphore semaphore;
        Dimension2D dimension2D = this.getFinalDimension(fileFormatOption.getDefaultStringBounder());
        double d = 0.0;
        double d2 = 0.0;
        if (animation != null) {
            MinMax minMax = this.animation.getMinMax(dimension2D);
            animation.setDimension(dimension2D);
            dimension2D = minMax.getDimension();
            d = -minMax.getMinX();
            d2 = -minMax.getMinY();
        }
        if ((semaphore = this.getSemaphore(n = this.getPrice(fileFormatOption, dimension2D))) != null) {
            try {
                semaphore.acquire(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new IOException(interruptedException);
            }
        }
        try {
            Object object;
            Object object2;
            UGraphic2 uGraphic2 = this.createUGraphic(fileFormatOption, l, dimension2D, animation, d, d2);
            UGraphic uGraphic = uGraphic2;
            if (this.externalMargin1 > 0.0) {
                uGraphic = uGraphic.apply(new UTranslate(this.externalMargin1, this.externalMargin1));
            }
            if (this.borderStroke != null) {
                object2 = this.borderColor == null ? HtmlColorUtils.BLACK : this.borderColor;
                object = new URectangle(dimension2D.getWidth() - this.externalMargin() - this.borderStroke.getThickness(), dimension2D.getHeight() - this.externalMargin() - this.borderStroke.getThickness(), this.borderCorner, this.borderCorner);
                uGraphic.apply(new UChangeColor((HtmlColor)object2)).apply(this.borderStroke).draw((UShape)object);
            }
            if (this.externalMargin1 > 0.0) {
                uGraphic = uGraphic.apply(new UTranslate(this.externalMargin2, this.externalMargin2));
            }
            uGraphic = uGraphic.apply(new UTranslate(this.margin1, this.margin1));
            object2 = this.handwritten(uGraphic);
            this.udrawable.drawU((UGraphic)object2);
            object2.flushUg();
            uGraphic2.writeImageTOBEMOVED(outputStream, this.metadata, 96);
            outputStream.flush();
            if (uGraphic2 instanceof UGraphicG2d && (object = ((UGraphicG2d)uGraphic2).getAllUrlsEncountered()).size() > 0) {
                CMapData cMapData = CMapData.cmapString((Set<Url>)object, this.dpiFactor);
                ImageDataComplex imageDataComplex = new ImageDataComplex(dimension2D, cMapData, this.warningOrError);
                return imageDataComplex;
            }
            object = new ImageDataSimple(dimension2D);
            return object;
        }
        finally {
            if (semaphore != null) {
                semaphore.release(n);
            }
        }
    }

    private double externalMargin() {
        return 2.0 * (this.externalMargin1 + this.externalMargin2);
    }

    public Dimension2D getFinalDimension(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2 + this.externalMargin(), limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2 + this.externalMargin());
        return dimension2DDouble;
    }

    private UGraphic handwritten(UGraphic uGraphic) {
        if (this.useHandwritten) {
            return new UGraphicHandwritten(uGraphic);
        }
        return uGraphic;
    }

    private ImageData writeImageMjpeg(OutputStream outputStream, StringBounder stringBounder) throws IOException {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        File file = new File("c:/tmp.avi");
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(file, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int n = 0;
        if (n < 100) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(((Dimension2D)dimension2DDouble).getWidth() / 2.0, ((Dimension2D)dimension2DDouble).getHeight() / 2.0);
            affineTransform.rotate(1.5707963267948966 * (double)n / 100.0);
            affineTransform.translate(-((Dimension2D)dimension2DDouble).getWidth() / 2.0, -((Dimension2D)dimension2DDouble).getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        mJPEGGenerator.finishAVI();
        FileUtils.copyToStream(file, outputStream);
        return new ImageDataSimple(dimension2DDouble);
    }

    private ImageData writeImageAnimatedGif(OutputStream outputStream, StringBounder stringBounder) throws IOException {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        MinMax minMax = this.animation.getMinMax(dimension2DDouble);
        AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
        animatedGifEncoder.setRepeat(0);
        animatedGifEncoder.start(outputStream);
        animatedGifEncoder.setDelay(60);
        for (AffineTransformation affineTransformation : this.animation.getAll()) {
            ImageIcon imageIcon = new ImageIcon(this.getAviImage(affineTransformation));
            animatedGifEncoder.addFrame((BufferedImage)imageIcon.getImage());
        }
        animatedGifEncoder.finish();
        return new ImageDataSimple(dimension2DDouble);
    }

    private Image getAviImage(AffineTransformation affineTransformation) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeImageInternal(new FileFormatOption(FileFormat.PNG), 42L, byteArrayOutputStream, Animation.singleton(affineTransformation));
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        byteArrayInputStream.close();
        return bufferedImage;
    }

    private UGraphic2 createUGraphic(FileFormatOption fileFormatOption, long l, Dimension2D dimension2D, Animation animation, double d, double d2) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        switch (fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(this.colorMapper, this.dpiFactor, dimension2D, this.mybackcolor, animation, d, d2);
            }
            case SVG: {
                return this.createUGraphicSVG(this.colorMapper, this.dpiFactor, dimension2D, this.mybackcolor, fileFormatOption.getSvgLinkTarget(), fileFormatOption.getHoverColor(), l);
            }
            case EPS: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(this.colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(this.colorMapper, this.dpiFactor, true);
            }
            case LATEX_NO_PREAMBLE: {
                return new UGraphicTikz(this.colorMapper, this.dpiFactor, false);
            }
            case BRAILLE_PNG: {
                return new UGraphicBraille(this.colorMapper, fileFormat);
            }
        }
        throw new UnsupportedOperationException(fileFormat.toString());
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, String string, String string2, long l) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        }
        UGraphicSvg uGraphicSvg = htmlColor instanceof HtmlColorGradient ? new UGraphicSvg(dimension2D, colorMapper, (HtmlColorGradient)htmlColor, false, d, string, string2, l) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(dimension2D, colorMapper, false, d, string, string2, l) : new UGraphicSvg(dimension2D, colorMapper, StringUtils.getAsHtml(color), false, d, string, string2, l));
        return uGraphicSvg;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, Animation animation, double d2, double d3) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        } else if (htmlColor instanceof HtmlColorTransparent) {
            color = null;
        }
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getWidth() * d), (int)(dimension2D.getHeight() * d), color);
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, d, animation == null ? null : animation.getFirst(), d2, d3);
        uGraphicG2d.setBufferedImage(emptyImageBuilder.getBufferedImage());
        BufferedImage bufferedImage = uGraphicG2d.getBufferedImage();
        if (htmlColor instanceof HtmlColorGradient) {
            uGraphicG2d.apply(new UChangeBackColor(htmlColor)).draw(new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return uGraphicG2d;
    }

    static {
        MAX_PRICE = 0;
    }
}

