/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;

    public DriverTextG2d(EnsureVisible ensureVisible) {
        this.visible = ensureVisible;
    }

    private static void printFont() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Log.info("Available fonts: " + stringArray[i]);
        }
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        int n;
        Cloneable cloneable;
        UText uText = (UText)uShape;
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont().scaled(uParam.getScale());
        Dimension2D dimension2D = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
        HtmlColor htmlColor = fontConfiguration.getExtendedColor();
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            Paint paint;
            cloneable = new Rectangle2D.Double(d, d2 - dimension2D.getHeight() + 1.5, dimension2D.getWidth(), dimension2D.getHeight());
            if (htmlColor instanceof HtmlColorGradient) {
                paint = DriverRectangleG2d.getPaintGradient(d, d2, colorMapper, dimension2D.getWidth(), dimension2D.getHeight(), htmlColor);
                graphics2D.setPaint(paint);
                graphics2D.fill((Shape)((Object)cloneable));
            } else {
                paint = colorMapper.getMappedColor(htmlColor);
                if (paint != null) {
                    graphics2D.setColor((Color)paint);
                    graphics2D.setBackground((Color)paint);
                    graphics2D.fill((Shape)((Object)cloneable));
                }
            }
        }
        this.visible.ensureVisible(d, d2 - dimension2D.getHeight() + 1.5);
        this.visible.ensureVisible(d + dimension2D.getWidth(), d2 + 1.5);
        graphics2D.setFont(uFont.getFont());
        graphics2D.setColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        graphics2D.drawString(uText.getText(), (float)d, (float)d2);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            cloneable = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
            int n2 = (int)(d2 + 2.5);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.drawLine((int)d, n2, (int)(d + ((Dimension2D)cloneable).getWidth()), n2);
            graphics2D.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            cloneable = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
            int n3 = (int)(d2 + 2.5) - 1;
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            n = (int)d;
            while ((double)n < d + ((Dimension2D)cloneable).getWidth() - 5.0) {
                graphics2D.drawLine(n, n3 - 0, n + 3, n3 + 1);
                graphics2D.drawLine(n + 3, n3 + 1, n + 6, n3 - 0);
                n += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            cloneable = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(), uFont, uText.getText());
            FontMetrics fontMetrics = graphics2D.getFontMetrics(uFont.getFont());
            n = (int)(d2 - (double)fontMetrics.getDescent() - 0.5);
            if (htmlColor != null) {
                graphics2D.setColor(colorMapper.getMappedColor(htmlColor));
            }
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.drawLine((int)d, n, (int)(d + ((Dimension2D)cloneable).getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
    }

    public static Dimension2D calculateDimension(StringBounder stringBounder, UFont uFont, String string) {
        Dimension2D dimension2D = stringBounder.calculateDimension(uFont, string);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        return new Dimension2DDouble(dimension2D.getWidth(), d);
    }
}

