/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class UEllipseHand {
    private Shadowable poly;

    public UEllipseHand(UEllipse uEllipse) {
        if (uEllipse.getStart() != 0.0 || uEllipse.getExtend() != 0.0) {
            this.poly = uEllipse;
            return;
        }
        this.poly = new UPolygon();
        double d = uEllipse.getWidth();
        double d2 = uEllipse.getHeight();
        double d3 = 0.0;
        if (d == d2) {
            while (d3 < Math.PI * 2) {
                double d4 = 1.0 + (Math.random() - 0.5) / 8.0;
                double d5 = d / 2.0 + Math.cos(d3 += (10.0 + Math.random() * 10.0) * Math.PI / 180.0) * d * d4 / 2.0;
                double d6 = d2 / 2.0 + Math.sin(d3) * d2 * d4 / 2.0;
                ((UPolygon)this.poly).addPoint(d5, d6);
            }
        } else {
            while (d3 < Math.PI * 2) {
                Point2D point2D = this.getPoint(d, d2, d3 += 0.15707963267948966);
                ((UPolygon)this.poly).addPoint(point2D.getX(), point2D.getY());
            }
        }
        this.poly.setDeltaShadow(uEllipse.getDeltaShadow());
    }

    private Point2D getPoint(double d, double d2, double d3) {
        double d4 = d / 2.0 + Math.cos(d3) * d / 2.0;
        double d5 = d2 / 2.0 + Math.sin(d3) * d2 / 2.0;
        double d6 = (Math.random() - 0.5) / 50.0;
        return new Point2D.Double(d4 + d6 * d, d5 + d6 * d2);
    }

    public Shadowable getHanddrawn() {
        return this.poly;
    }
}

