/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.utils.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverRectangleTikz
implements UDriver<TikzGraphics> {
    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, TikzGraphics tikzGraphics) {
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getWidth();
        double d4 = uRectangle.getHeight();
        double d5 = MathUtils.min(uRectangle.getRx(), uRectangle.getRy(), d3 / 2.0, d4 / 2.0);
        tikzGraphics.setFillColor(colorMapper.getMappedColor(uParam.getBackcolor()));
        tikzGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
        tikzGraphics.setStrokeWidth(uParam.getStroke().getThickness(), uParam.getStroke().getDashTikz());
        if (d5 == 0.0) {
            tikzGraphics.rectangle(d, d2, d3, d4);
        } else {
            tikzGraphics.rectangleRound(d, d2, d3, d4, d5);
        }
    }
}

