/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.vizjs;

import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.vizjs.GraphvizJsRuntimeException;
import net.sourceforge.plantuml.vizjs.VizJsEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizJs
implements Graphviz {
    private static final ExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            return new JsThread(runnable);
        }
    });
    private final String dotString;

    public GraphvizJs(String string) {
        this.dotString = string;
    }

    @Override
    public ProcessState createFile3(OutputStream outputStream) {
        try {
            String string = this.submitJob().get();
            outputStream.write(string.getBytes());
            return ProcessState.TERMINATED_OK();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GraphvizJsRuntimeException(exception);
        }
    }

    private Future<String> submitJob() {
        return executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                JsThread jsThread = (JsThread)Thread.currentThread();
                VizJsEngine vizJsEngine = jsThread.engine;
                return vizJsEngine.execute(GraphvizJs.this.dotString);
            }
        });
    }

    @Override
    public File getDotExe() {
        return null;
    }

    @Override
    public String dotVersion() {
        return "VizJs";
    }

    @Override
    public ExeState getExeState() {
        return ExeState.OK;
    }

    public static GraphvizVersion getGraphvizVersion(final boolean bl) {
        return new GraphvizVersion(){

            public boolean useShield() {
                return true;
            }

            public boolean useProtectionWhenThereALinkFromOrToGroup() {
                return true;
            }

            public boolean modeSafe() {
                return bl;
            }

            public boolean isVizjs() {
                return true;
            }
        };
    }

    static class JsThread
    extends Thread {
        private final Runnable runnable;
        private VizJsEngine engine;

        public JsThread(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            if (this.engine == null) {
                try {
                    this.engine = new VizJsEngine();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.runnable.run();
        }
    }
}

