/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.utils.UniqueSequence;
import net.sourceforge.plantuml.version.Version;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmi.IXmiClassDiagram;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmiDescriptionDiagram
implements IXmiClassDiagram {
    private final DescriptionDiagram diagram;
    private final Document document;
    private final Element ownedElement;

    public XmiDescriptionDiagram(DescriptionDiagram descriptionDiagram) throws ParserConfigurationException {
        this.diagram = descriptionDiagram;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element element = this.document.createElement("XMI");
        element.setAttribute("xmi.version", "1.1");
        element.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(element);
        Element element2 = this.document.createElement("XMI.header");
        element.appendChild(element2);
        Element element3 = this.document.createElement("XMI.metamodel");
        element3.setAttribute("xmi.name", "UML");
        element3.setAttribute("xmi.version", "1.3");
        element2.appendChild(element3);
        Element element4 = this.document.createElement("XMI.content");
        element.appendChild(element4);
        Element element5 = this.document.createElement("UML:Model");
        element5.setAttribute("xmi.id", CucaDiagramXmiMaker.getModel(descriptionDiagram));
        element5.setAttribute("name", "PlantUML " + Version.versionString());
        element4.appendChild(element5);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        element5.appendChild(this.ownedElement);
        for (IGroup removeable : descriptionDiagram.getGroups(false)) {
            if (!(removeable.getParentContainer() instanceof GroupRoot)) continue;
            this.addState(removeable, this.ownedElement);
        }
        for (IEntity iEntity : descriptionDiagram.getLeafsvalues()) {
            if (!(iEntity.getParentContainer() instanceof GroupRoot)) continue;
            this.addState(iEntity, this.ownedElement);
        }
        for (Link link : descriptionDiagram.getLinks()) {
            this.addLink(link);
        }
    }

    private void addState(IEntity iEntity, Element element) {
        Element element2 = this.createEntityNode(iEntity);
        element.appendChild(element2);
        for (IEntity iEntity2 : this.diagram.getGroups(false)) {
            if (iEntity2.getParentContainer() != iEntity) continue;
            this.addState(iEntity2, element2);
        }
        for (IEntity iEntity2 : this.diagram.getLeafsvalues()) {
            if (iEntity2.getParentContainer() != iEntity) continue;
            this.addState(iEntity2, element2);
        }
    }

    public static String forXMI(String string) {
        return string.replace(':', ' ');
    }

    public static String forXMI(Display display) {
        return display.get(0).toString().replace(':', ' ');
    }

    private void addLink(Link link) {
        String string = "ass" + UniqueSequence.getValue();
        Element element = this.document.createElement("UML:Association");
        element.setAttribute("xmi.id", string);
        element.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.diagram));
        if (!Display.isNull(link.getLabel())) {
            element.setAttribute("name", XmiDescriptionDiagram.forXMI(link.getLabel()));
        }
        Element element2 = this.document.createElement("UML:Association.connection");
        Element element3 = this.document.createElement("UML:AssociationEnd");
        element3.setAttribute("xmi.id", "end" + UniqueSequence.getValue());
        element3.setAttribute("association", string);
        element3.setAttribute("type", link.getEntity1().getUid());
        if (link.getQualifier1() != null) {
            element3.setAttribute("name", XmiDescriptionDiagram.forXMI(link.getQualifier1()));
        }
        Element element4 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            element3.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
            element3.setAttribute("aggregation", "aggregate");
        }
        element3.appendChild(element4);
        element2.appendChild(element3);
        Element element5 = this.document.createElement("UML:AssociationEnd");
        element5.setAttribute("xmi.id", "end" + UniqueSequence.getValue());
        element5.setAttribute("association", string);
        element5.setAttribute("type", link.getEntity2().getUid());
        if (link.getQualifier2() != null) {
            element5.setAttribute("name", XmiDescriptionDiagram.forXMI(link.getQualifier2()));
        }
        Element element6 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            element5.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
            element5.setAttribute("aggregation", "aggregate");
        }
        element5.appendChild(element6);
        element2.appendChild(element5);
        element.appendChild(element2);
        this.ownedElement.appendChild(element);
    }

    private Element createEntityNode(IEntity iEntity) {
        Element element;
        Element element2 = this.document.createElement("UML:Component");
        element2.setAttribute("xmi.id", iEntity.getUid());
        element2.setAttribute("name", iEntity.getDisplay().get(0).toString());
        element2.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.diagram));
        Element element3 = this.document.createElement("UML:Classifier.feature");
        element2.appendChild(element3);
        for (Member member : iEntity.getBodier().getFieldsToDisplay()) {
            element = this.document.createElement("UML:Attribute");
            element.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            element.setAttribute("name", member.getDisplay(false));
            element3.appendChild(element);
        }
        for (Member member : iEntity.getBodier().getMethodsToDisplay()) {
            element = this.document.createElement("UML:Operation");
            element.setAttribute("xmi.id", "att" + UniqueSequence.getValue());
            element.setAttribute("name", member.getDisplay(false));
            element3.appendChild(element);
        }
        return element2;
    }

    public void transformerXml(OutputStream outputStream) throws TransformerException, ParserConfigurationException {
        DOMSource dOMSource = new DOMSource(this.document);
        StreamResult streamResult = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(dOMSource, streamResult);
    }
}

